package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.annotation.DictTrans;
import cn.sinozg.applet.common.constant.BaseConstants;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/**
* 字典工具类
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 10:03
**/
public class DictTransUtil {

    private DictTransUtil(){
    }
    /**
     * 数据转义
     * @param value 原始值
     * @param dict 对应的注解
     * @return  转义后的值
     */
    public static String dictTrans (String value, DictTrans dict){
        String targetValue = null;
        if (StringUtils.isNotBlank(value)) {
            if (ArrayUtils.isNotEmpty(dict.pairs())) {
                String[] kv;
                for (String pair : dict.pairs()) {
                    kv = StringUtils.split(pair, BaseConstants.COLON);
                    if (kv[0].equals(value)) {
                        targetValue = kv[1];
                        break;
                    }
                }
            } else {
                targetValue = DictUtil.getDictLabel(dict.type() ,value);
            }
        }
        return targetValue;
    }

}
