package cn.sinozg.applet.common.customizer;

import cn.sinozg.applet.common.annotation.JsonField;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.handlers.PostInitTableInfoHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * 通过自定义注解的方式
 * 主动转json 对象
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-06-02 14:35
 */
@Component
public class PostInitTableInfoHandlerCustomizer implements PostInitTableInfoHandler {

    private static final Logger log = LoggerFactory.getLogger(PostInitTableInfoHandlerCustomizer.class);

    @Override
    public TableInfo creteTableInfo(Configuration configuration, Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        boolean hasJson = false;
        String typeName = "typeHandler";
        try {
            for (Field field : fields) {
                JsonField jsonField = field.getAnnotation(JsonField.class);
                if (jsonField == null) {
                    continue;
                }
                TableField tableField = field.getAnnotation(TableField.class);
                Class<?> handler = tableField.typeHandler();
                if (handler == UnknownTypeHandler.class) {
                    PojoUtil.setAnnotationValue(tableField, typeName, JacksonTypeHandler.class);
                    hasJson = true;
                }
                if (hasJson) {
                    TableName tableName = clazz.getAnnotation(TableName.class);
                    if (tableName != null && !tableName.autoResultMap()) {
                        PojoUtil.setAnnotationValue(tableName, "autoResultMap", true);
                    }
                }
            }
        } catch (Exception e) {
            log.error("通过注解设置json字段错误，", e);
        }
        return new TableInfo(configuration, clazz);
    }
}
