package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.enums.DatePattern;
import cn.sinozg.applet.common.serializer.UtcOutSerializer;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 国际化时区 出参处理
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-24 17:48
 */
@Target(ElementType.FIELD)
@JacksonAnnotationsInside
@Retention(RetentionPolicy.RUNTIME)
@JsonSerialize(using = UtcOutSerializer.class)
public @interface UtcOut {
    DatePattern pattern() default DatePattern.DATE_TIME_PATTERN;
}
