package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.UtcIn;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;

/**
 * 时间根据utc 转为 utc时间
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-24 17:49
 */
public class UtcInDeserializer extends JsonDeserializer<LocalDateTime> implements ContextualDeserializer {

    private String pattern;

    @Override
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        if (jsonParser != null) {
            String text = jsonParser.getText();
            if (StringUtils.isNotBlank(text)) {
                // 获取到动态时区
                String utc = UserUtil.utc();
                LocalDateTime ldt = DateUtil.parseDateTime(text, pattern);
                return DateUtil.ldtUtc(ldt, utc);
            }
        }
        return null;

    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty property) throws JsonMappingException {
        if (TirsciUtil.isTimeField(property)) {
            UtcIn utc = property.getAnnotation(UtcIn.class);
            if (utc == null) {
                utc = property.getContextAnnotation(UtcIn.class);
            }
            if (utc != null) {
                this.pattern = TirsciUtil.utcPattern(utc.pattern(), () -> UserUtil.user().getOther());
                return this;
            }
        }
        return null;
    }
}
