package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.UtcOut;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;

/**
 * 时间根据utc 转为 显示时间
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-24 17:51
 */
public class UtcOutSerializer extends JsonSerializer<LocalDateTime> implements ContextualSerializer {

    private String pattern;

    @Override
    public void serialize(LocalDateTime ldt, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        //写原值
        String timeStr = StringUtils.EMPTY;
        if (ldt != null) {
            // 获取到动态时区
            String utc = UserUtil.utc();
            LocalDateTime utcLdt = DateUtil.ldtUtc(ldt, utc);
            timeStr = DateUtil.formatDateTime(utcLdt, pattern);
        }
        gen.writeObject(timeStr);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty property) throws JsonMappingException {
        if (property != null && LocalDateTime.class.isAssignableFrom(property.getType().getRawClass())) {
            UtcOut utc = property.getAnnotation(UtcOut.class);
            if (utc != null) {
                this.pattern = TirsciUtil.utcPattern(utc.pattern(), () -> UserUtil.user().getOther());
                return this;
            }
        }
        return null;
    }
}
