package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.annotation.DictTrans;
import cn.sinozg.applet.common.annotation.I18nField;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.exception.CavException;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.List;

/**
* 字典工具类
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 10:03
**/
public class DictTransUtil {

    private static final Logger log = LoggerFactory.getLogger(DictTransUtil.class);

    private DictTransUtil(){
    }
    /**
     * 数据转义
     * @param value 原始值
     * @param dict 对应的注解
     * @return  转义后的值
     */
    public static String dictTrans (String value, DictTrans dict){
        String targetValue = null;
        if (StringUtils.isNotBlank(value)) {
            if (ArrayUtils.isNotEmpty(dict.pairs())) {
                String[] kv;
                for (String pair : dict.pairs()) {
                    kv = StringUtils.split(pair, BaseConstants.COLON);
                    if (kv[0].equals(value)) {
                        targetValue = kv[1];
                        break;
                    }
                }
            } else {
                targetValue = DictUtil.getDictLabel(dict.type() ,value);
            }
        }
        return targetValue;
    }

    /**
     * 对对象进行国际化翻译
     * @param t 对象
     * @param request 请求
     * @param <T> 类型
     */
    public static <T> void setBeanI18n(T t, HttpServletRequest request) {
        if (t == null) {
            return;
        }
        if (request == null) {
            request = WebUtil.request();
        }
        List<Field> fields = PojoUtil.allField(t.getClass());
        String name;
        try {
            for (Field field : fields) {
                I18nField fieldAnnotation = field.getAnnotation(I18nField.class);
                if (fieldAnnotation != null) {
                    name = I18nUtil.propertyName(request, fieldAnnotation.value());
                    PojoUtil.setValue(t, field, name);
                }
            }
        } catch (Exception e) {
            log.error("设置值错误。", e);
            throw new CavException("BIZ000100062");
        }
    }
}
