/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.annotation.DictTrans;
import cn.sinozg.applet.common.annotation.I18nField;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.DictUtil;
import cn.sinozg.applet.common.utils.I18nUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictTransUtil {
    private static final Logger log = LoggerFactory.getLogger(DictTransUtil.class);

    private DictTransUtil() {
    }

    public static String dictTrans(String value, DictTrans dict) {
        String targetValue = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (ArrayUtils.isNotEmpty((Object[])dict.pairs())) {
                for (String pair : dict.pairs()) {
                    String[] kv = StringUtils.split((String)pair, (String)":");
                    if (!kv[0].equals(value)) continue;
                    targetValue = kv[1];
                    break;
                }
            } else {
                targetValue = DictUtil.getDictLabel((DictType)dict.type(), (String)value);
            }
        }
        return targetValue;
    }

    public static <T> void setBeanI18n(T t, HttpServletRequest request) {
        if (t == null) {
            return;
        }
        if (request == null) {
            request = WebUtil.request();
        }
        List fields = PojoUtil.allField(t.getClass());
        try {
            for (Field field : fields) {
                I18nField fieldAnnotation = field.getAnnotation(I18nField.class);
                if (fieldAnnotation == null) continue;
                String name = I18nUtil.propertyName((HttpServletRequest)request, (String)fieldAnnotation.value(), (Object[])new Object[0]);
                PojoUtil.setValue(t, (Field)field, (Object)name);
            }
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u503c\u9519\u8bef\u3002", (Throwable)e);
            throw new CavException("BIZ000100062");
        }
    }
}

