/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.annotation.DictTrans;
import cn.sinozg.applet.common.annotation.I18nField;
import cn.sinozg.applet.common.core.model.I18nName;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.recode.DictPairCache;
import cn.sinozg.applet.common.utils.DictUtil;
import cn.sinozg.applet.common.utils.I18nUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictTransUtil {
    private static final Logger log = LoggerFactory.getLogger(DictTransUtil.class);
    private static final Map<String, DictPairCache> DICT_MAP = new ConcurrentHashMap<String, DictPairCache>();

    private DictTransUtil() {
    }

    public static String dictTrans(String value, DictTrans dict) {
        String targetValue = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            targetValue = ArrayUtils.isNotEmpty((Object[])dict.pairs()) ? DictTransUtil.dictPair(value, dict.pairs()) : DictUtil.getDictLabel((DictType)dict.type(), (String)value);
        }
        return targetValue;
    }

    public static String dictPair(String value, String[] pairs) {
        if (ArrayUtils.isNotEmpty((Object[])pairs)) {
            DictPairCache cache = DictTransUtil.dictPairCache(pairs);
            boolean isI18n = cache.i18n();
            Locale locale = null;
            if (isI18n) {
                locale = DictUtil.dictLocale();
            }
            if (locale == null) {
                locale = Locale.CHINA;
            }
            Map<String, I18nName> map = cache.map();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return I18nUtil.getDictName((I18nName)map.get(value), (Locale)locale);
            }
            StringBuilder result = new StringBuilder();
            for (Map.Entry<String, I18nName> e : map.entrySet()) {
                result.append(e.getKey()).append(":");
                if (e.getValue() != null) {
                    result.append(e.getValue().getName()).append(" ");
                }
                result.append(" ");
            }
            return result.toString();
        }
        return null;
    }

    public static <T> void setBeanI18n(T t, HttpServletRequest request) {
        if (t == null) {
            return;
        }
        if (request == null) {
            request = WebUtil.request();
        }
        List fields = PojoUtil.allField(t.getClass());
        try {
            for (Field field : fields) {
                I18nField fieldAnnotation = field.getAnnotation(I18nField.class);
                if (fieldAnnotation == null) continue;
                String name = I18nUtil.propertyName((HttpServletRequest)request, (String)fieldAnnotation.value(), (Object[])new Object[0]);
                PojoUtil.setValue(t, (Field)field, (Object)name);
            }
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u503c\u9519\u8bef\u3002", (Throwable)e);
            throw new CavException("BIZ000100062");
        }
    }

    private static DictPairCache dictPairCache(String[] pairs) {
        String key = StringUtils.join((Object[])pairs, (String)",");
        if (!DICT_MAP.containsKey(key)) {
            HashMap<String, I18nName> map = new HashMap<String, I18nName>();
            boolean isI18n = false;
            for (String pair : pairs) {
                I18nName i18nName;
                String k = StringUtils.substringBefore((String)pair, (String)":").trim();
                String v = StringUtils.substringAfter((String)pair, (String)":").trim();
                if (!isI18n && StringUtils.startsWith((CharSequence)v, (CharSequence)"{") && StringUtils.endsWith((CharSequence)v, (CharSequence)"}")) {
                    isI18n = true;
                }
                if (isI18n) {
                    i18nName = (I18nName)JsonUtil.toPojo((String)v, I18nName.class);
                } else {
                    i18nName = new I18nName();
                    i18nName.setName(k);
                }
                map.put(k, i18nName);
            }
            DICT_MAP.put(key, new DictPairCache(isI18n, map));
        }
        return DICT_MAP.get(key);
    }
}

