/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.serializer.DictFieldSerializer;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据字典转义<br/>
 * pairs 国际化的话 value值为{@link cn.sinozg.applet.common.core.model.I18nName} 的json 字符串
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2022-11-14 下午 09:27
*/
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@JacksonAnnotationsInside
@JsonSerialize(using = DictFieldSerializer.class)
public @interface DictTrans {

    /** 根据数据库的数据转义 **/
    DictType type() default DictType.ROOT_TYPE;

    /** 自定义的数值键值对 如 {"01:男", "02:女"}  或者 value是 I18nName json 对象*/
    String[] pairs() default {};
}
