/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.enums.RateLimiterUnit;
import org.apache.commons.lang3.StringUtils;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 接口限流 滑动窗口模式 基于ip 或者key 实现对接口的限流<p/>
 * 支持spEL的方式获取到参数作为key进行锁定
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-13 21:19
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RateLimiter {

    /** id 默认为 packageName + method */
    String id() default StringUtils.EMPTY;

    /** 为空，则默认为ip，有值，则限制对应的值，支持spEL表达式 */
    String key() default StringUtils.EMPTY;

    /** 限制访问次数 默认1分钟 60次 */
    int limit() default 60;
    /** 限制单位 默认分钟 */
    RateLimiterUnit unit() default RateLimiterUnit.MINUTES;
}
