/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.UtcIn;
import cn.sinozg.applet.common.enums.DatePattern;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.commons.lang3.StringUtils;

public class UtcInDeserializer
extends JsonDeserializer<LocalDateTime>
implements ContextualDeserializer {
    private String pattern;

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        String text;
        if (jsonParser != null && StringUtils.isNotBlank((CharSequence)(text = jsonParser.getText()))) {
            String utc = UserUtil.utc();
            LocalDateTime ldt = DateUtil.parseDateTime((String)text, (String)this.pattern);
            return DateUtil.ldtUtc((LocalDateTime)ldt, (String)utc);
        }
        return null;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty property) throws JsonMappingException {
        UtcIn utc = (UtcIn)PojoUtil.annotationSerializable((BeanProperty)property, (boolean)true, UtcIn.class, (Class[])new Class[]{LocalDateTime.class, LocalTime.class, LocalDate.class});
        if (utc != null) {
            this.pattern = TirsciUtil.utcPattern((DatePattern)utc.pattern(), () -> UserUtil.user().getOther());
            return this;
        }
        return null;
    }
}

