/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.PicUrl;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.StringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;

/**
 * 使用注解的方式修改图片显示地址
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:44
 **/
public class PicUrlFieldSerializer extends JsonSerializer<String> implements ContextualSerializer {

    /** 字段 */
    private String fieldName;
    /**
     * 序列化图片id为图片地址
     * @param value 图片id
     * @param gen JsonGenerator
     * @param serializers 序列化对象
     * @throws IOException 异常
     */
    @Override
    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String showUrl = StringUtil.showUrl(value);
        // 写原值
        if (StringUtils.isBlank(showUrl)) {
            gen.writeObject(null);
        } else {
            gen.writeObject(value);
        }
        // 以追加Url 显示地址
        gen.writeObjectField(this.fieldName, showUrl);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        PicUrl picUrl = PojoUtil.annotationSerializable(property, false, PicUrl.class);
        if (picUrl != null) {
            this.fieldName = property.getName() + BaseConstants.PIC_URL;
            return this;
        }
        return null;
    }
}
