/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.ConditionalField;
import cn.sinozg.applet.common.annotation.ConditionalRequired;
import cn.sinozg.applet.common.utils.I18nUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalRequiredValidator
implements ConstraintValidator<ConditionalRequired, Object> {
    private static final Logger log = LoggerFactory.getLogger(ConditionalRequiredValidator.class);
    private ConditionalField[] rules;

    public void initialize(ConditionalRequired annotation) {
        this.rules = annotation.value();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        boolean valid = true;
        for (ConditionalField rule : this.rules) {
            try {
                Field dependsField = clazz.getDeclaredField(rule.dependsOn());
                dependsField.setAccessible(true);
                Object dependsValue = dependsField.get(value);
                Field field = clazz.getDeclaredField(rule.field());
                field.setAccessible(true);
                Object fieldValue = field.get(value);
                if (ArrayUtils.isEmpty((Object[])rule.eq()) && ArrayUtils.isEmpty((Object[])rule.ne())) break;
                boolean needNotBlank = false;
                String depends = Objects.toString(dependsValue, "");
                if (ArrayUtils.isNotEmpty((Object[])rule.eq()) && Strings.CS.equalsAny((CharSequence)depends, (CharSequence[])rule.eq())) {
                    needNotBlank = true;
                }
                if (ArrayUtils.isNotEmpty((Object[])rule.ne()) && !Strings.CS.equalsAny((CharSequence)depends, (CharSequence[])rule.ne())) {
                    needNotBlank = true;
                }
                if (!needNotBlank || fieldValue != null && !fieldValue.toString().trim().isEmpty()) continue;
                valid = false;
                this.setMessage(rule, context);
            }
            catch (Exception e) {
                log.error("\u53cd\u5c04\u53d6\u503c\u5f02\u5e38:", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return valid;
    }

    private void setMessage(ConditionalField rule, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        String message = rule.message();
        if (StringUtils.isNotBlank((CharSequence)message) && JsonUtil.isJson((String)message)) {
            message = StringUtils.substringBetween((String)message, (String)"{", (String)"}");
            message = I18nUtil.propertyName((String)message, (Object[])new Object[0]);
        }
        context.buildConstraintViolationWithTemplate(message).addPropertyNode(rule.field()).addConstraintViolation();
    }
}

