package cn.sinozg.applet.common.exception;

import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.utils.TirsciUtil;
import org.apache.commons.lang3.StringUtils;


/**
 * 全局业务异常
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:41
 **/
public class CavException extends RuntimeException {

	/** 业务code */
	private String code;

	/** 异常信息参数 */
	private final Object[] params;

	/**
	 * 业务异常
	 * @param code 业务异常dode
	 */
	public CavException(String code) {
		this(code, (Object) null);
	}

	/**
	 * 直接复制异常，抛出到页面
	 * @param e 异常
	 */
	public CavException(Exception e){
		this(StringUtils.defaultString(e.getMessage(), BaseConstants.GLOBAL_EXCEPTION_MESSAGE), e);
	}

	/**
	 * 业务异常，复制了其他异常的栈堆信息
	 * @param code 错误信息
	 * @param e 异常
	 */
	public CavException(String code, Exception e) {
		this(code, e, (Object) null);
	}

	/**
	 * 业务异常
	 * @param code 业务异常dode
	 * @param params 业务参数
	 */
	public CavException(String code, Object... params) {
		this(code, null, params);
	}

	/**
	 * 业务异常
	 * @param code 业务异常dode
	 * @param e 抛出来的 异常
	 * @param params 参数
	 */
	public CavException (String code, Exception e, Object... params){
		super(code, e);
		// 如果是国际化的
		if (code.startsWith(BaseConstants.EXP_PREFIX)) {
			this.code = code;
			this.params = params;
		} else {
			this.code = BaseConstants.DEFAULT_CODE;
			Object[] arrays = new Object[1];
			arrays[0] = TirsciUtil.format(code, params);
			this.params = arrays;
		}
	}

	/**
	 * 获取 业务code
	 *
	 * @return code 业务code
	 */
	public String getCode() {
		return this.code;
	}

	/**
	 * 设置 业务code
	 *
	 * @param code 业务code
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * 获取 异常信息参数
	 *
	 * @return params 异常信息参数
	 */
	public Object[] getParameters() {
		return this.params;
	}
}
