/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.constant.OmConstants;
import cn.sinozg.applet.common.core.model.JsonNodeInfo;
import cn.sinozg.applet.common.enums.NodeType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    protected static final ObjectMapper OM = OmConstants.getOm();
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static String printerJson(Object obj) {
        try {
            return OM.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("\u5bf9\u8c61\u8f6cjson\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("\u5bf9\u8c61\u8f6cjson\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static String toJson(Object obj) {
        try {
            return OM.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("\u5bf9\u8c61\u8f6cjson\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("\u5bf9\u8c61\u8f6cjson\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, T> toMap(String json) {
        try {
            return (Map)OM.readValue(json, new TypeReference<Map<String, T>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json\u8f6cmap\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("json\u8f6cmap\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static <T> T mapPojo(Map<String, Object> map, Class<T> clazz) {
        if (MapUtils.isEmpty(map) || clazz == null) {
            return null;
        }
        String json = JsonUtil.toJson(map);
        return JsonUtil.toPojo(json, clazz);
    }

    public static <T> T toPojo(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            OM.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)OM.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            log.error("json\u8f6cbean\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("json\u8f6cbean\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static <T> T toPojo(String json, Function<ObjectMapper, JavaType> function) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            OM.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JavaType javaType = function.apply(OM);
            return (T)OM.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            log.error("json\u8f6cbean\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("json\u8f6cbean\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toPojos(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            JavaType javaType = JsonUtil.getCollectionType(ArrayList.class, clazz);
            return (List)OM.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            log.error("json\u8f6cbean\u96c6\u5408\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("json\u8f6cbean\u96c6\u5408\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static <T> T nodeBean(JsonNode node, Class<T> clazz) {
        try {
            OM.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)OM.treeToValue((TreeNode)node, clazz);
        }
        catch (JsonProcessingException e) {
            log.error("jsonNode\u8f6cbean\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("jsonNode\u8f6cbean\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return OM.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String key2Val(String json, String key) {
        try {
            JsonNode node = OM.readTree(json);
            if (node != null && (node = node.findValue(key)) != null) {
                return node.toString();
            }
        }
        catch (JsonProcessingException e) {
            log.error("\u83b7\u53d6json\u8282\u70b9\u7684\u503c\u9519\u8bef\uff0c{}", (Object)e.getMessage());
        }
        return null;
    }

    public static String key2Val(String json, List<JsonNodeInfo> infos) {
        if (StringUtils.isBlank((CharSequence)json) || CollectionUtils.isEmpty(infos)) {
            return null;
        }
        JsonNode temp = null;
        try {
            JsonNode node = OM.readTree(json);
            if (node != null) {
                temp = JsonUtil.nodeValue(node, infos.get(0));
                int j = infos.size();
                for (int i = 1; i < j && temp != null; ++i) {
                    temp = JsonUtil.nodeValue(temp, infos.get(i));
                }
            }
        }
        catch (JsonProcessingException e) {
            log.error("\u83b7\u53d6json\u8282\u70b9\u7684\u503c\u9519\u8bef\uff0c{}", (Object)e.getMessage());
            log.error("\u83b7\u53d6json\u8282\u70b9\u7684\u503c\u9519\u8bef!", (Throwable)e);
        }
        if (temp == null) {
            return null;
        }
        return temp.asText();
    }

    private static JsonNode nodeValue(JsonNode node, JsonNodeInfo info) {
        JsonNode result = null;
        if (info.getType() == NodeType.FIND) {
            result = node.findValue(info.getValue());
        } else if (info.getType() == NodeType.AT) {
            result = node.at(info.getValue());
        } else if (node.isArray()) {
            int index = info.getIndex();
            if (index < 0) {
                index = node.size() + index;
            }
            result = node.get(index);
        }
        return result;
    }

    public static ObjectMapper om() {
        return OM;
    }

    public static <T extends Serializable> JsonNode toNode(T t) {
        return OM.valueToTree(t);
    }
}

