/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.core.ThreadFun;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolExecutorHandler
extends ThreadPoolExecutor {
    private final String poolName;
    private static final long KEEP_ALIVE_TIME = 300L;
    private static final int QUEUE_CAPACITY = 8192;
    private static final Logger log = LoggerFactory.getLogger((String)"bizCustomLevelLog");

    public ThreadPoolExecutorHandler(String poolName) {
        this(poolName, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public ThreadPoolExecutorHandler(String poolName, RejectedExecutionHandler handler) {
        this(ThreadFun.CORE_POOL_SIZE + 1, ThreadFun.CORE_POOL_SIZE + 1, 300L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(8192), poolName, handler);
    }

    public ThreadPoolExecutorHandler(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, String poolName, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ThreadFun.threadFactory(poolName), handler);
        this.poolName = poolName;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (log.isDebugEnabled()) {
            BlockingQueue<Runnable> queue = this.getQueue();
            log.debug("{}: \u521d\u59cb\u7ebf\u7a0b\u6570: {}, \u6838\u5fc3\u7ebf\u7a0b\u6570: {}, \u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u6570\u91cf: {}, \u6c60\u4e2d\u5b58\u5728\u7684\u6700\u5927\u7ebf\u7a0b\u6570: {}, \u6700\u5927\u5141\u8bb8\u7684\u7ebf\u7a0b\u6570: {},\u5df2\u5b8c\u6210\u4efb\u52a1\u6570\u91cf: {}, \u5386\u53f2\u4efb\u52a1\u603b\u6570: {}, \u961f\u5217\u91cc\u7f13\u5b58\u7684\u4efb\u52a1\u6570\u91cf: {}, \u961f\u5217\u5269\u4f59\u5927\u5c0f\uff1a{}", new Object[]{this.poolName, this.getPoolSize(), this.getCorePoolSize(), this.getActiveCount(), this.getLargestPoolSize(), this.getMaximumPoolSize(), this.getCompletedTaskCount(), this.getTaskCount(), queue.size(), queue.remainingCapacity()});
        }
        super.beforeExecute(t, r);
    }
}

