/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.PojoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.Response;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final Map<String, String> MIME_TYPE = new HashMap<String, String>();
    private static final TikaConfig CONFIG = TikaConfig.getDefaultConfig();
    private static final Tika TIKA = new Tika(CONFIG);

    public static File multipartFileToFile(MultipartFile multipartFile) {
        File file;
        if (multipartFile == null) {
            return null;
        }
        try {
            file = File.createTempFile("multipart_file", multipartFile.getOriginalFilename());
            file.deleteOnExit();
            FileUtils.writeByteArrayToFile((File)file, (byte[])multipartFile.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MultipartFile multipartFile(File file) {
        if (file == null) {
            return null;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            MultipartFile multipartFile = FileUtil.multipartFile(fis, file.getName());
            return multipartFile;
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8f6c MultipartFile \u5bf9\u8c61\u9519\u8bef\uff01", (Throwable)e);
            throw new CavException("BIZ000100028");
        }
    }

    /*
     * Exception decompiling
     */
    public static MultipartFile multipartFile(InputStream is, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeBuffer(InputStream is, OutputStream os) throws IOException {
        int bytesRead;
        int cacheLength = 8192;
        byte[] buffer = new byte[cacheLength];
        while ((bytesRead = is.read(buffer, 0, cacheLength)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
    }

    public static String fileType(String fileName) {
        Optional optional = MediaTypeFactory.getMediaType((String)fileName);
        return optional.orElse(MediaType.TEXT_PLAIN).toString();
    }

    public static boolean judgeFile(MultipartFile file, String ... arrays) {
        return FileUtil.judgeFile(FileUtil.multipartFileToFile(file), arrays);
    }

    public static String fileType(File file) {
        String fileType;
        if (file == null || file.isDirectory()) {
            return null;
        }
        try {
            fileType = TIKA.detect(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (MIME_TYPE.isEmpty()) {
            FileUtil.initMimeType();
        }
        return fileType;
    }

    public static boolean judgeFile(File file, String ... arrays) {
        if (ArrayUtils.isEmpty((Object[])arrays)) {
            return false;
        }
        String fileType = FileUtil.fileType(file);
        String extension = MIME_TYPE.get(fileType);
        if (StringUtils.isBlank((CharSequence)extension)) {
            log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a{}", (Object)fileType);
            return false;
        }
        for (String ext : arrays) {
            if (!StringUtils.startsWith((CharSequence)ext, (CharSequence)".")) {
                ext = "." + ext;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)ext)) continue;
            return true;
        }
        log.error("\u89e3\u6790\u51fa\u6765\u7684\u6587\u4ef6\u683c\u5f0f\u4e3a\uff1a{}\uff0c\u8981\u5224\u65ad\u7684\u6587\u4ef6\u683c\u5f0f\u4e3a\uff1a{}", (Object)extension, (Object)arrays);
        return false;
    }

    public static String getHeaderFileName(Response response) {
        String[] strings;
        String dispositionHeader = response.header("Content-Disposition");
        if (StringUtils.isNotEmpty((CharSequence)dispositionHeader) && (strings = dispositionHeader.split(";")).length > 1) {
            dispositionHeader = strings[1].replace("filename=", "");
            dispositionHeader = dispositionHeader.replace("\"", "");
            return dispositionHeader.trim();
        }
        return "";
    }

    private static void initMimeType() {
        MimeTypes types = CONFIG.getMimeRepository();
        Object o = PojoUtil.getProperty((Object)types, "types");
        Map map = (Map)PojoUtil.cast(o);
        if (MapUtils.isNotEmpty((Map)map)) {
            for (Map.Entry e : map.entrySet()) {
                MIME_TYPE.put(((MimeType)e.getValue()).toString(), ((MimeType)e.getValue()).getExtension());
            }
        }
    }
}

