/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.ThreadFun;
import cn.sinozg.applet.common.handler.ThreadPoolExecutorHandler;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool {
    private static final int SHUT_TIME = 120;
    private static final Logger log = LoggerFactory.getLogger(ThreadPool.class);
    private static final ExecutorService TTL_SERVICE = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutorHandler("biz-ttl-pool"));
    private static final ThreadPoolExecutor SINGLE_THREAD_POOL = new ThreadPoolExecutorHandler("common-pool", (r, executor) -> {
        try {
            executor.getQueue().put(r);
        }
        catch (InterruptedException e) {
            log.error("\u521d\u59cb\u5316\u666e\u901a\u7ebf\u7a0b\u9519\u8bef\uff01", (Throwable)e);
        }
    });

    private ThreadPool() {
    }

    public static void submit(Runnable runnable) {
        SINGLE_THREAD_POOL.submit(runnable);
    }

    public static void execute(Runnable runnable) {
        SINGLE_THREAD_POOL.execute(runnable);
    }

    public static void ttlExecute(Runnable r) {
        assert (TTL_SERVICE != null);
        TTL_SERVICE.execute(r);
    }

    public static void shutdownAndAwaitTermination() {
        ThreadPool.shutdownAndAwaitTermination(SINGLE_THREAD_POOL);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        if (pool != null && !pool.isShutdown()) {
            pool.shutdown();
            try {
                if (!pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                        log.info("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                log.error("\u7ebf\u7a0b\u95ed\u5173\u5931\u8d25\uff01", (Throwable)ie);
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void printException(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            log.error(t.getMessage(), t);
        }
    }

    public static ScheduledThreadPoolExecutor scheduledThread(String poolName) {
        return new ScheduledThreadPoolExecutor(1, ThreadFun.threadFactory(poolName));
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(ScheduledThreadPoolExecutor executor, Runnable command, Duration initialDelay, Duration delay) {
        return executor.scheduleWithFixedDelay(command, initialDelay.getSeconds(), delay.getSeconds(), TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(ScheduledThreadPoolExecutor executor, Runnable command, Duration initialDelay, Duration period) {
        return executor.scheduleAtFixedRate(command, initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS);
    }
}

