/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.constant.OmConstants;
import cn.sinozg.applet.common.core.model.JsonNodeInfo;
import cn.sinozg.applet.common.core.model.MapJsonTemp;
import cn.sinozg.applet.common.enums.NodeType;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.function.FunctionException;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    protected static final ObjectMapper OM = OmConstants.getOm();
    protected static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static String printerJson(Object obj) {
        return JsonUtil.tryParse(m -> m.writerWithDefaultPrettyPrinter().writeValueAsString(obj));
    }

    public static String toJson(Object obj) {
        return JsonUtil.tryParse(m -> m.writeValueAsString(obj));
    }

    public static Map<String, Object> toMap(String json) {
        Map value = JsonUtil.tryParse(m -> (Map)m.readValue(json, Map.class));
        return (Map)PojoUtil.cast(value);
    }

    public static <T> Map<String, T> toMap(String json, Class<T> clazz) {
        MapJsonTemp temp;
        if (StringUtils.isNotEmpty((CharSequence)json) && clazz != null && (temp = (MapJsonTemp)JsonUtil.toPojo(json = "{\"map\":" + json + "}", (ObjectMapper om) -> om.getTypeFactory().constructParametricType(MapJsonTemp.class, new Class[]{clazz}))) != null) {
            return temp.getMap();
        }
        return null;
    }

    public static <T> T mapPojo(Map<String, Object> map, Class<T> clazz) {
        if (MapUtils.isEmpty(map) || clazz == null) {
            return null;
        }
        String json = JsonUtil.toJson(map);
        return JsonUtil.toPojo(json, clazz);
    }

    public static <T> T toPojo(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JsonUtil.tryParse(m -> {
            m.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return m.readValue(json, clazz);
        });
    }

    public static <T> T toPojo(String json, Function<ObjectMapper, JavaType> function) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JsonUtil.tryParse(m -> {
            m.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JavaType javaType = (JavaType)function.apply((ObjectMapper)m);
            return m.readValue(json, javaType);
        });
    }

    public static <T> List<T> toPojos(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return JsonUtil.tryParse(m -> {
            JavaType javaType = JsonUtil.getCollectionType(ArrayList.class, clazz);
            return (List)m.readValue(json, javaType);
        });
    }

    public static <T> T nodeBean(JsonNode node, Class<T> clazz) {
        return (T)JsonUtil.tryParse(m -> {
            m.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return m.treeToValue((TreeNode)node, clazz);
        });
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return OM.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String key2Val(String json, String key) {
        return JsonUtil.tryParse(m -> {
            JsonNode node = m.readTree(json);
            if (node != null && (node = node.findValue(key)) != null) {
                return node.toString();
            }
            return null;
        });
    }

    public static String key2Val(String json, List<JsonNodeInfo> infos) {
        JsonNode node = JsonUtil.key2Node(json, infos);
        if (node != null) {
            return node.asText();
        }
        return null;
    }

    public static JsonNode key2Node(String json, List<JsonNodeInfo> infos) {
        if (StringUtils.isBlank((CharSequence)json) || CollectionUtils.isEmpty(infos)) {
            return null;
        }
        return JsonUtil.tryParse(m -> {
            JsonNode node = m.readTree(json);
            JsonNode n = null;
            if (node != null) {
                n = JsonUtil.nodeValue(node, (JsonNodeInfo)infos.get(0));
                int j = infos.size();
                for (int i = 1; i < j && n != null; ++i) {
                    n = JsonUtil.nodeValue(n, (JsonNodeInfo)infos.get(i));
                }
            }
            return n;
        });
    }

    private static JsonNode nodeValue(JsonNode node, JsonNodeInfo info) {
        JsonNode result = null;
        if (info.getType() == NodeType.FIND) {
            result = node.findValue(info.getValue());
        } else if (info.getType() == NodeType.AT) {
            result = node.at(info.getValue());
        } else if (node.isArray()) {
            int index = info.getIndex();
            if (index < 0) {
                index = node.size() + index;
            }
            result = node.get(index);
        }
        return result;
    }

    public static ObjectMapper om() {
        return OM;
    }

    public static <T extends Serializable> JsonNode toNode(T t) {
        return OM.valueToTree(t);
    }

    public static <T> T tryParse(FunctionException<ObjectMapper, T> parse) {
        return JsonUtil.tryParse(parse, OM);
    }

    protected static <T> T tryParse(FunctionException<ObjectMapper, T> parse, ObjectMapper om) {
        try {
            return parse.apply(om);
        }
        catch (Exception e) {
            log.error("json \u5904\u7406\u5f02\u5e38!", (Throwable)e);
            throw new CavException("JSON handling exception!");
        }
    }
}

