/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.TreeSelect;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.JsonUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.web.method.HandlerMethod;

public class PojoUtil {
    private static final Map<String, BeanCopier> BEAN_COPIER_MAP = new ConcurrentHashMap<String, BeanCopier>();
    private static final Pattern PATTERN = Pattern.compile("([^&=]+)=([^&=]+)");
    private static final Logger logger = LoggerFactory.getLogger(PojoUtil.class);
    private static final int BATCH_SIZE = 500;

    private PojoUtil() {
    }

    public static <R, T> List<T> copyList(List<R> resources, Class<T> clazz) {
        return PojoUtil.copyList(resources, clazz, null);
    }

    public static <R, T> List<T> copyList(List<R> resources, Class<T> clazz, BiConsumer<R, T> consumer) {
        return PojoUtil.copy(resources, null, clazz, consumer);
    }

    public static <T> T cast(Object o) {
        if (o != null) {
            return (T)o;
        }
        return null;
    }

    public static boolean single(Collection<?> collection) {
        return CollectionUtils.isNotEmpty(collection) && collection.size() == 1;
    }

    public static List<String> singleToList(String input) {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            String[] arrays = StringUtils.split((String)input.trim(), (String)",");
            return PojoUtil.arrayToList(arrays);
        }
        return new ArrayList<String>();
    }

    @SafeVarargs
    public static <T> ArrayList<T> arrayToList(T ... ts) {
        if (ts == null) {
            throw new NullPointerException();
        }
        int arraySize = ts.length;
        int capacity = PojoUtil.cast(5L + (long)arraySize + (long)(arraySize / 10));
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, ts);
        return list;
    }

    public static <T, R> List<R> toList(Collection<T> list, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T> List<T> toList(Collection<T> list, Predicate<T> filter, Consumer<T> peek) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        Stream stream = list.stream();
        if (filter != null) {
            stream = stream.filter(filter);
        }
        if (peek != null) {
            stream = stream.peek(peek);
        }
        return stream.collect(Collectors.toList());
    }

    public static <K, T> Map<K, List<T>> groupMap(List<T> list, Function<? super T, ? extends K> keyMapper) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap(16);
        }
        return list.stream().collect(Collectors.groupingBy(keyMapper));
    }

    public static <K, T, R> Map<K, List<R>> groupMapList(List<T> list, Function<? super T, ? extends K> keyMapper, Function<T, R> valueMapper) {
        HashMap map = new HashMap(64);
        if (CollectionUtils.isNotEmpty(list)) {
            for (T t : list) {
                K key = keyMapper.apply(t);
                ArrayList<R> result = (ArrayList<R>)map.get(key);
                if (result == null) {
                    result = new ArrayList<R>();
                }
                R r = valueMapper.apply(t);
                result.add(r);
                map.put(key, result);
            }
        }
        return map;
    }

    public static <K, T> Map<K, T> toMap(List<T> list, Function<? super T, ? extends K> keyMapper) {
        return PojoUtil.toMap(list, keyMapper, Function.identity());
    }

    public static <T, K, U> Map<K, U> toMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return PojoUtil.toMap(list, keyMapper, valueMapper, (o, n) -> n);
    }

    public static <T, K, U> Map<K, U> toMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap(64);
        }
        return list.stream().collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction));
    }

    public static <V> Map<String, V> sortMap(Map<String, V> map) {
        return PojoUtil.sortMap(map, Function.identity(), String::compareTo);
    }

    public static <K, V, U> Map<K, V> sortMap(Map<K, V> map, Function<? super K, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        LinkedHashMap linkMap = new LinkedHashMap();
        if (MapUtils.isNotEmpty(map)) {
            ArrayList<K> keys = new ArrayList<K>(map.keySet());
            List sortKeyList = keys.stream().sorted(Comparator.comparing(keyExtractor, keyComparator)).collect(Collectors.toList());
            for (Object k : sortKeyList) {
                linkMap.put(k, map.get(k));
            }
        }
        return linkMap;
    }

    public static <T> T[] toArray(List<T> list, Class<T> clazz) {
        if (list == null || clazz == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(array);
    }

    public static <T, R> void setBeanList(T t, R r, Function<T, List<R>> get, BiConsumer<T, List<R>> set) {
        if (t == null || r == null) {
            return;
        }
        List<R> list = get.apply(t);
        if (list == null) {
            list = new ArrayList<R>();
        }
        list.add(r);
        set.accept(t, list);
    }

    public static List<Field> allField(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (clazz != null) {
            Object[] fs = clazz.getDeclaredFields();
            if (ArrayUtils.isNotEmpty((Object[])fs)) {
                list.addAll(PojoUtil.arrayToList(fs));
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static Field fieldByName(Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return PojoUtil.fieldByName(clazz.getSuperclass(), fieldName);
        }
    }

    public static Class<?> getGenericType(Type type) {
        ParameterizedType tp;
        Type[] typeArguments;
        Type gt;
        if (type instanceof ParameterizedType && (gt = (typeArguments = (tp = (ParameterizedType)PojoUtil.cast(type)).getActualTypeArguments())[0]) instanceof Class) {
            return (Class)PojoUtil.cast(gt);
        }
        return null;
    }

    public static void setProperty(Object bean, String name, Object value) {
        Class<?> clazz = bean.getClass();
        try {
            Field field = PojoUtil.fieldByName(clazz, name);
            PojoUtil.setValue(bean, field, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u53cd\u5c04\u8d4b\u503c\u9519\u8bef!", (Throwable)e);
        }
    }

    public static void setAnnotationValue(Annotation annotation, String name, Object value) throws Exception {
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        Field field = handler.getClass().getDeclaredField("memberValues");
        field.setAccessible(true);
        Map values = (Map)PojoUtil.cast(field.get(handler));
        values.put(name, value);
    }

    public static Object getProperty(Object bean, String name) {
        Class<?> clazz = bean.getClass();
        try {
            Field field = PojoUtil.fieldByName(clazz, name);
            if (field != null) {
                field.setAccessible(true);
                return field.get(bean);
            }
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u53d6\u503c\u9519\u8bef!", (Throwable)e);
        }
        return null;
    }

    public static Object getProperty(Object bean, Field field) {
        try {
            field.setAccessible(true);
            return field.get(bean);
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u53d6\u503c\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    private static int cast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static <T> T paramsBean(String query, Class<T> clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>(64);
        Matcher m = PATTERN.matcher(query);
        while (m.find()) {
            map.put(m.group(1), m.group(2));
        }
        return JsonUtil.mapPojo(map, clazz);
    }

    public static <R, T> T copyBean(R r, Class<T> clazz) {
        if (r == null || clazz == null) {
            return null;
        }
        T t = null;
        try {
            t = PojoUtil.newInstance(clazz);
            PojoUtil.copyBean(r, t);
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
        }
        return t;
    }

    public static <R, T> void copyBean(R r, T t) {
        PojoUtil.copy(Collections.singletonList(r), t, t.getClass(), null);
    }

    private static <R, T> List<T> copy(List<R> resources, T target, Class<T> clazz, BiConsumer<R, T> consumer) {
        ArrayList<T> list = new ArrayList<T>();
        if (CollectionUtils.isEmpty(resources)) {
            return list;
        }
        try {
            BeanCopier copier = PojoUtil.beanCopier(resources.get(0).getClass(), clazz);
            for (R r : resources) {
                T t = target == null ? PojoUtil.newInstance(clazz) : target;
                copier.copy(r, t, null);
                if (consumer != null) {
                    consumer.accept(r, t);
                }
                list.add(t);
            }
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u5f02\u5e38", (Throwable)e);
        }
        return list;
    }

    public static <T> T map2Bean(Map<String, String[]> source, Class<T> clazz) throws Exception {
        if (source == null || clazz == null) {
            return null;
        }
        T t = PojoUtil.newInstance(clazz);
        BeanInfo info = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        Object[] ps = new Object[1];
        for (PropertyDescriptor pd : pds) {
            String key = pd.getName();
            if (!source.containsKey(key)) continue;
            ps[0] = source.get(key);
            pd.getWriteMethod().invoke(t, ps);
        }
        return t;
    }

    private static <R, T> BeanCopier beanCopier(Class<R> r, Class<T> t) {
        BeanCopier copier;
        String beanKey = r.toString() + t.toString();
        if (BEAN_COPIER_MAP.containsKey(beanKey)) {
            copier = BEAN_COPIER_MAP.get(beanKey);
        } else {
            copier = BeanCopier.create(r, t, (boolean)false);
            BEAN_COPIER_MAP.put(beanKey, copier);
        }
        return copier;
    }

    /*
     * Exception decompiling
     */
    public static <T extends Serializable> List<T> deepCopy(List<T> resources) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setValue(Object o, Field field, Object v) throws IllegalAccessException {
        if (field != null && o != null) {
            field.setAccessible(true);
            field.set(o, v);
        }
    }

    public static <T> List<List<T>> executeBatch(Collection<T> params, Consumer<List<T>> consumer) {
        return PojoUtil.executeBatch(params, 500, c -> c, consumer);
    }

    public static <T, R> List<R> batchList(Collection<T> params, Function<List<T>, R> function) {
        return PojoUtil.executeBatch(params, 500, function, null);
    }

    public static <T, R> List<R> executeBatch(Collection<T> params, int batchSize, Function<List<T>, R> function, Consumer<R> consumer) {
        ArrayList<T> subs = new ArrayList<T>();
        ArrayList<R> list = new ArrayList<R>();
        if (CollectionUtils.isNotEmpty(params)) {
            int size = params.size();
            int idxLimit = Math.min(batchSize, size);
            int i = 1;
            for (T t : params) {
                subs.add(t);
                if (i == idxLimit) {
                    R r = function.apply(subs);
                    list.add(r);
                    if (consumer != null) {
                        consumer.accept(r);
                    }
                    subs = new ArrayList();
                    idxLimit = Math.min(idxLimit + batchSize, size);
                }
                ++i;
            }
        }
        return list;
    }

    public static <T> T newInstance(Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <T> List<TreeSelect> toTree(List<T> resources, Function<T, TreeSelect> fun, String root) {
        if (CollectionUtils.isEmpty(resources)) {
            return null;
        }
        List<TreeSelect> list = PojoUtil.toList(resources, fun);
        return PojoUtil.toTree(list, root);
    }

    public static <T extends TreeSelect> List<T> toTree(List<T> resources, String root) {
        ArrayList<TreeSelect> tree = new ArrayList<TreeSelect>();
        for (TreeSelect t : resources) {
            boolean isRoot = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{root, t.getParId()}) || StringUtils.isNotBlank((CharSequence)root) && root.equals(t.getParId());
            if (!isRoot) continue;
            tree.add(t);
        }
        PojoUtil.children(tree, resources);
        tree.sort(Comparator.comparing(TreeSelect::getSeqNo));
        return tree;
    }

    private static <T extends TreeSelect> void children(List<T> tree, List<T> sources) {
        for (TreeSelect sub : tree) {
            ArrayList<TreeSelect> list = new ArrayList<TreeSelect>();
            for (TreeSelect s : sources) {
                if (!sub.getId().equals(s.getParId())) continue;
                list.add(s);
            }
            if (!CollectionUtils.isNotEmpty(list)) continue;
            list.sort(Comparator.comparing(TreeSelect::getSeqNo));
            sub.setChildren(list);
            PojoUtil.children(list, sources);
        }
    }

    public static Method getMethod(Object o, String methodName, Class<?> ... classTypes) {
        Class<?> clazz;
        Method method = null;
        for (Class<?> superClass = clazz = o.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            try {
                if (ArrayUtils.isEmpty((Object[])classTypes)) {
                    method = superClass.getDeclaredMethod(methodName, new Class[0]);
                    break;
                }
                method = superClass.getDeclaredMethod(methodName, classTypes);
                break;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                continue;
            }
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    public static <T extends Annotation> T getAnnotation(HandlerMethod method, Class<T> clazz) {
        T t = method.getBeanType().getAnnotation(clazz);
        if (t == null) {
            t = method.getMethod().getAnnotation(clazz);
        }
        return t;
    }

    public static <T> List<Class<T>> subClasses(Class<T> clazz, String basePackage) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(clazz));
        Set set = provider.findCandidateComponents(basePackage);
        ArrayList<Class<T>> list = new ArrayList<Class<T>>();
        try {
            for (BeanDefinition beanDefinition : set) {
                Class<?> c = Class.forName(beanDefinition.getBeanClassName());
                list.add((Class<T>)PojoUtil.cast(c));
            }
        }
        catch (Exception e) {
            throw new CavException("\u83b7\u53d6\u5b50\u7c7b\u9519\u8bef\uff01", e);
        }
        return list;
    }
}

