/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.function.SupplierException;
import java.security.SecureRandom;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class TirsciUtil {
    private static final Logger log = LoggerFactory.getLogger(TirsciUtil.class);
    private static final SecureRandom RANDOM = new SecureRandom();

    private TirsciUtil() {
    }

    public static <T> T tryCatch(SupplierException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String format(String strPattern, Object ... argArray) {
        if (StringUtils.isEmpty((CharSequence)strPattern) || ArrayUtils.isEmpty((Object[])argArray)) {
            return strPattern;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)strPattern, (Object[])argArray);
        return tuple.getMessage();
    }

    public static int nextInt(int bound) {
        return RANDOM.nextInt(bound);
    }
}

