package cn.sinozg.applet.common.core;

import org.apache.commons.lang3.concurrent.BasicThreadFactory;

import java.util.concurrent.ThreadFactory;

/**
 * 线程相关的方法
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-22 20:28
 */
public class ThreadFun {
    /** 核心数 **/
    public static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();

    /**
     * 获取到 线程 工厂
     * @param poolName 线程名称
     * @return ThreadFactory
     */
    public static ThreadFactory threadFactory (String poolName) {
        return new BasicThreadFactory.Builder()
                .namingPattern(poolName + "-%d").daemon(true).build();
    }
}
