/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.serializer;

import cn.sinozg.applet.common.annotation.Regex;
import cn.sinozg.applet.common.enums.RegexType;
import cn.sinozg.applet.common.utils.IdCardUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexValidator
implements ConstraintValidator<Regex, String> {
    private Regex regex;

    public void initialize(Regex annotation) {
        this.regex = annotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            if (this.regex.required()) {
                this.setMessage(true, context);
            }
            return !this.regex.required();
        }
        Pattern pattern = Pattern.compile(this.regex.type().getRegexp());
        Matcher matcher = pattern.matcher(value);
        boolean result = matcher.matches();
        if (result && this.regex.type() == RegexType.ID_CARD) {
            result = StringUtils.isBlank((CharSequence)IdCardUtil.idCard(value));
        }
        if (!result) {
            this.setMessage(false, context);
        }
        return result;
    }

    private void setMessage(boolean required, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(this.regex.type().getMsg() + (required ? "\u4e0d\u80fd\u4e3a\u7a7a\uff01" : "\u683c\u5f0f\u4e0d\u6b63\u786e\uff01")).addConstraintViolation();
    }
}

