/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.suport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class StandardMultipartFile
implements MultipartFile,
Serializable {
    private final DiskFileItem fileItem;
    private final String filename;

    public StandardMultipartFile(DiskFileItem fileItem, String filename) {
        this.fileItem = fileItem;
        this.filename = filename;
    }

    @NotNull
    public String getName() {
        return this.fileItem.getName();
    }

    public String getOriginalFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public boolean isEmpty() {
        return this.fileItem.getSize() == 0L;
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public byte @NotNull [] getBytes() throws IOException {
        return FileCopyUtils.copyToByteArray((InputStream)this.fileItem.getInputStream());
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        this.fileItem.write(Paths.get(dest.getPath(), new String[0]));
        if (dest.isAbsolute() && !dest.exists()) {
            FileCopyUtils.copy((InputStream)this.fileItem.getInputStream(), (OutputStream)Files.newOutputStream(dest.toPath(), new OpenOption[0]));
        }
    }

    public void transferTo(@NotNull Path dest) throws IOException, IllegalStateException {
        FileCopyUtils.copy((InputStream)this.fileItem.getInputStream(), (OutputStream)Files.newOutputStream(dest, new OpenOption[0]));
    }
}

