package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.utils.PojoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ssl 证书 相关
 * 可以通过设置CRT的方式
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-10-18 14:06
 */
public class SslSocket {

    public static List<String> CRT;

    private static final Logger LOG = LoggerFactory.getLogger(SslSocket.class);

    /**
     * 创建有证书连接
     * @return 连接
     */
    public static ImmutablePair<SSLSocketFactory, X509TrustManager> sslSocketFactory(){
        if (CRT != null) {
            List<InputStream> iss = new ArrayList<>();
            try {
                for (String s : CRT) {
                    iss.add(Files.newInputStream(Paths.get(s)));
                }
                return sslSocketFactory(iss);
            } catch (Exception e) {
                LOG.error("创建证书的工厂错误！", e);
                throw new RuntimeException("Factory error in creating certificate!");
            }
        }
        return null;
    }

    /**
     * 创建证书的ssl 工厂
     * @param ios 证书流
     * @return 工厂
     */
    public static ImmutablePair<SSLSocketFactory, X509TrustManager> sslSocketFactory (List<InputStream> ios){
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            // Create a KeyStore containing the trusted root certificates
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            try {
                for (int i = 0, size = ios.size(); i < size; ) {
                    InputStream is = ios.get(i);
                    keyStore.setCertificateEntry(Integer.toString(i++), cf.generateCertificate(is));
                    if (is != null) {
                        is.close();
                    }
                }
            } catch (IOException e) {
                LOG.error("读取证书流错误！", e);
                throw new RuntimeException("read certificate io error!");
            }
            // Create a TrustManager that trusts the CAs in our KeyStore
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            SSLSocketFactory factory = sslContext.getSocketFactory();
            return ImmutablePair.of(factory, sslTrustManager(keyStore));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * socket 工厂
     * @param manager 管理器
     * @return socket
     */
    public static SSLSocketFactory socketFactory(TrustManager manager) {
        SSLSocketFactory factory;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{manager}, new SecureRandom());
            factory = sslContext.getSocketFactory();
        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            throw new RuntimeException(e);
        }
        return factory;
    }

    /**
     * 带证书的 管理器
     * @param keyStore 证书
     * @return 管理器
     * @throws Exception 异常
     */
    public static X509TrustManager sslTrustManager(KeyStore keyStore) throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return PojoUtil.cast(trustManagers[0]);
    }

    /**
     * X509TrustManager
     * @return X509TrustManager
     */
    public static X509TrustManager trustManager() {
        return new X509TrustManager() {

            @Override
            public void checkClientTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    /**
     * 域名校验
     * @return 校验结果
     */
    public static HostnameVerifier hostnameVerifier() {
        return (s, sslSession) -> true;
    }
}
