package cn.sinozg.applet.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 字段是枚举值的，将枚举键对显示在swagger上
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-12-10 12:21
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface EnumField {

    /** 实现对 枚举类的类型 */
    Class<?> clazz();
    /** 枚举类的 key 对应的名称 */
    String key() default "code";

    /** 枚举类的 name 对应的名称 */
    String name() default "name";
}
