/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.constant;


/**
 * 通用常量信息
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:29
 **/
public class BaseConstants {
    /** UTF-8 字符集 */
    public static final String UTF8 = "UTF-8";
    /** 包名称 */
    public static final String BASE_PACKAGE = "cn.sinozg.applet";
    /** 配置前缀 */
    public static final String APP_PREFIX = "app";
    /** . */
    public static final String SPOT = ".";
    /** 逗号 */
    public static final String COMMA = ",";
    /** 冒号 */
    public static final String COLON = ":";
    /** 所有的 * 号 */
    public static final String ALL = "*";
    /** 中间线 */
    public static final String MIDDLE_LINE = "-";
    /** 下划线 */
    public static final String UNDERLINE = "_";
    /** @ */
    public static final String AT = "@";
    /** # */
    public static final String POUND_SIGN = "#";

    /** 空json */
    public static final String EMPTY_JSON = "{}";
    /** \ */
    public static final char C_BACKSLASH = '\\';
    /** JSON开始 */
    public static final String JSON_START = "{";

    /** JSON结尾 */
    public static final String JSON_END = "}";
    /** json格式 */
    public static final String APPLICATION_JSON = "application/json; charset=utf-8";

    /** 错误前缀 */
    public static final String EXP_PREFIX = "BIZ";
    /** 忽略多租户 */
    public static final String IGNORE = "true";
    /** 数据根节点 */
    public static final String DICT_ROOT = "JBY_ROOT";
    /** GBK 字符集 */
    public static final String GBK = "GBK";

    /** 通用成功标识 */
    public static final String SUCCESS = "00";

    /** 通用失败标识 */
    public static final String FAIL = "01";
    /** 通用成功标识 */
    public static final String SUC = "SUCCESS";

    /** 通用失败标识 */
    public static final String FA = "FAIL";

    /** 全局异常默认提示：服务有点问题，请稍候 */
    public static final String GLOBAL_EXCEPTION_MESSAGE = "BIZ000100015";

    /** 默认错误码 **/
    public static final String DEFAULT_CODE = "BIZ000100017";
    /** 没有权限 **/
    public static final String FORBIDDEN_CODE = "BIZ000100034";
    /** 数据状态正常 */
    public static final String STATUS_COMMON = "00";

    /** 数据状态 停用 */
    public static final String STATUS_STOP = "01";

    /** 00 */
    public static final String STATUS_00 = "00";

    /** 01 */
    public static final String STATUS_01 = "01";
    /** 02 */
    public static final String STATUS_02 = "02";
    /** 数据字典转描述 Desc */
    public static final String DICT_DESC = "Desc";

    /** 业务日志 级别为 error的 */
    public static final String BIZ_CUSTOM_LOG = "bizCustomLevelLog";
    /** 异常解析器 */
    public static final String EXCEPTION_RESOLVER = "handlerExceptionResolver";
    /** 国际化 */
    public static final String LOCALE_RESOLVER = "appletLocaleResolver";
    /** redis 对象 */
    public static final String REDIS_OBJ = "objRedisTemplate";
    /** redis string 对象 */
    public static final String REDIS_STR = "stringRedisTemplate";
    /** 默认延迟线程池 */
    public static final String SCHEDULED_BEAN = "scheduledExecutorService";
    /** xls */
    public static final String XLS = ".xls";
    /** xlsx */
    public static final String XLSX = ".xlsx";
    /** 链路 跟踪 id */
    public static final String TRACE_ID = "traceId";
    /** 自定义 utc 格式 */
    public static final String CUSTOMIZE_UTC_PATTERN = "utcPattern";
}
