/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.enums;

/**
 * 业务操作类型
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2022-11-14 下午 09:37
*/
public enum BizType {
    /** 其它 */
    OTHER("00"),

    /** 新增 */
    INSERT("01"),

    /** 修改 */
    UPDATE("02"),

    /** 删除 */
    DELETE("03"),

    /** 授权 */
    GRANT("04"),

    /** 导出 */
    EXPORT("05"),

    /** 导入 */
    IMPORT("06"),

    /** 强退 */
    FORCE("07"),

    /** 生成代码 */
    GEN_CODE("08"),

    /** 清空数据 */
    CLEAN("09"),

    /** 查询 */
    SELECT("10");

    /** code */
    private final String code;

    BizType(String code){
        this.code = code;
    }

    /**
     * 获取 code
     *
     * @return code code值
     */
    public String getCode() {
        return this.code;
    }
}
