/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.enums.DatePattern;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.function.SupplierException;
import com.fasterxml.jackson.databind.BeanProperty;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class TirsciUtil {
    private static final Logger log = LoggerFactory.getLogger(TirsciUtil.class);
    private static final SecureRandom RANDOM = new SecureRandom();

    private TirsciUtil() {
    }

    public static <T> T tryCatch(SupplierException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String format(String strPattern, Object ... argArray) {
        if (StringUtils.isEmpty((CharSequence)strPattern) || ArrayUtils.isEmpty((Object[])argArray)) {
            return strPattern;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)strPattern, (Object[])argArray);
        return tuple.getMessage();
    }

    public static int nextInt(int bound) {
        return RANDOM.nextInt(bound);
    }

    public static boolean isTimeField(BeanProperty property) {
        if (property != null) {
            Class clazz = property.getType().getRawClass();
            return LocalDateTime.class.isAssignableFrom(clazz) || LocalTime.class.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz);
        }
        return false;
    }

    public static String utcPattern(DatePattern pattern, Supplier<Map<String, Object>> supplier) {
        if (pattern == DatePattern.CUSTOMIZE) {
            Map<String, Object> object = supplier.get();
            String utcPattern = MapUtils.getString(object, (Object)"utcPattern");
            if (StringUtils.isBlank((CharSequence)utcPattern)) {
                throw new CavException("BIZ000100061");
            }
            return utcPattern;
        }
        return pattern.getPattern();
    }
}

