/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.constant;

/**
 * 微信支付头信息
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-24 下午 10:18
 **/
public class HeaderConstants {

    /** 时间戳 */
    public static final String TIMESTAMP = "Wechatpay-Timestamp";
    /** 随机数 */
    public static final String NONCE = "Wechatpay-Nonce";
    /** 检验信息 */
    public static final String SIGNATURE = "Wechatpay-Signature";
    /** 序列号 */
    public static final String SERIAL = "Wechatpay-Serial";

    /** 本地参数校验 */
    public static final String X_TIMESTAMP = "Whj-Timestamp";
    /** 本地参数校验 签名值 */
    public static final String X_SIGNATURE = "Whj-Signature";
    /** 本地参数校验 随机数 */
    public static final String X_NONCE = "Whj-Nonce";
    /** 不进行加密，单独接口使用 */
    public static final String X_NO_ENCRYPT = "Whj-Encrypt";

    /** 本地参数校验 RSA 客户端公钥 */
    public static final String X_PUB_KEY = "Whj-Pub-Key";

    /** 链路 跟踪 id */
    public static final String X_TRACE_ID = "Whj-Trace-Id";

}