/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.enums.ChronoDate;
import cn.sinozg.applet.common.utils.ArithUtil;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String MDHSS = "MMddHHmmssSSS";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String HHMM = "HHmm";
    public static final String HH_MM = "HH:mm";
    public static final String HHMMSS = "HHmmss";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String[] YMD_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yyyyMMdd"};
    public static final String[] YMDHMS_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyyMMddHHmmss"};
    public static final String[] HMS_PATTERNS = new String[]{"HH:mm:ss", "HHmmss"};
    public static final ZoneOffset ZONE_BJ = ZoneOffset.of("+8");

    public static String getDateTime() {
        return DateUtil.formatDateTime(LocalDateTime.now());
    }

    public static String getDate() {
        return DateUtil.formatDate(LocalDate.now(), YYYY_MM_DD);
    }

    public static String getTime() {
        return DateUtil.formatTime(LocalTime.now(), HH_MM_SS);
    }

    public static String nextDate(String ymd, int daysToAdd, TemporalUnit unit) {
        LocalDate date = DateUtil.parseDate(ymd).plus(daysToAdd, unit);
        if (unit == ChronoUnit.WEEKS || unit == ChronoUnit.MONTHS || unit == ChronoUnit.YEARS) {
            date = date.plusDays(daysToAdd < 0 ? 1L : -1L);
        }
        return DateUtil.formatDate(date, YYYY_MM_DD);
    }

    public static LocalDateTime parseDateTime(String input) {
        return DateUtil.parseDateTime(input, YYYY_MM_DD_HH_MM_SS);
    }

    public static LocalDateTime parseDateTime(String input, String pattern) {
        return DateUtil.parse(pattern, input, LocalDateTime::from);
    }

    public static LocalDate parseDate(String input) {
        return DateUtil.parseDate(input, YYYY_MM_DD);
    }

    public static LocalDate parseDate(String input, String pattern) {
        return DateUtil.parse(pattern, input, LocalDate::from);
    }

    public static LocalTime parseTime(String input) {
        return DateUtil.parseTime(input, HH_MM_SS);
    }

    public static LocalTime parseTime(String input, String pattern) {
        return DateUtil.parse(pattern, input, LocalTime::from);
    }

    public static LocalDateTime ymdToLdt(String input) {
        input = (String)input + " 00:00:00";
        return DateUtil.parseDateTime((String)input);
    }

    public static LocalDateTime ymdToLdtEnd(String input) {
        input = (String)input + " 23:59:59";
        return DateUtil.parseDateTime((String)input);
    }

    public static String poorSeconds(int seconds) {
        LocalDateTime ldt = LocalDateTime.now();
        return DateUtil.getDatePoor(ldt, ldt.plusSeconds(seconds));
    }

    public static String getDatePoor(LocalDateTime startDate, LocalDateTime endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        Duration duration = Duration.between(startDate, endDate);
        if (duration.isNegative()) {
            return null;
        }
        LocalDate endLd = endDate.toLocalDate();
        if (startDate.toLocalTime().isAfter(endDate.toLocalTime())) {
            endLd = endLd.minusDays(1L);
        }
        Period period = Period.between(startDate.toLocalDate(), endLd);
        StringBuilder poor = new StringBuilder();
        DateUtil.appendPoor(poor, period.getYears(), "\u5e74");
        DateUtil.appendPoor(poor, period.getMonths(), "\u6708");
        DateUtil.appendPoor(poor, period.getDays(), "\u5929");
        DateUtil.appendPoor(poor, duration.toHours() % 24L, "\u5c0f\u65f6");
        DateUtil.appendPoor(poor, duration.toMinutes() % 60L, "\u5206\u949f");
        double second = ArithUtil.div(duration.toMillis(), 1000.0);
        second = ArithUtil.round(second, 0);
        DateUtil.appendPoor(poor, (long)(second % 60.0), "\u79d2");
        return poor.toString();
    }

    private static void appendPoor(StringBuilder poor, long num, String unit) {
        if (num > 0L) {
            poor.append(num).append(unit);
        }
    }

    public static long diffTime(LocalDateTime startDate, LocalDateTime endDate) {
        Duration duration = Duration.between(startDate, endDate);
        return duration.toMillis();
    }

    public static long diffSeconds(LocalDateTime startDate, LocalDateTime endDate) {
        Duration duration = Duration.between(startDate, endDate);
        return duration.toSeconds();
    }

    public static boolean compareTime(Object source, Object target) {
        if (source == null || !source.getClass().isInstance(target)) {
            return false;
        }
        if (source instanceof String) {
            String s = (String)source;
            String t = (String)target;
            Comparable<ChronoLocalDateTime<?>> t1 = null;
            Comparable<ChronoLocalDateTime<?>> t2 = null;
            if (t.length() == s.length()) {
                if (t.length() == YYYY_MM_DD_HH_MM_SS.length()) {
                    t1 = DateUtil.parseDateTime(s);
                    t2 = DateUtil.parseDateTime(t);
                } else if (t.length() == YYYY_MM_DD.length()) {
                    t1 = DateUtil.parseDate(s);
                    t2 = DateUtil.parseDate(t);
                } else if (t.length() == HH_MM_SS.length()) {
                    t1 = DateUtil.parseTime(s);
                    t2 = DateUtil.parseTime(t);
                }
                return DateUtil.compare(t1, t2);
            }
        }
        return DateUtil.compare(source, target);
    }

    private static boolean compare(Object source, Object target) {
        if (target == null || !(source instanceof Temporal)) {
            return false;
        }
        if (source instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)source;
            return ldt.isBefore((LocalDateTime)target);
        }
        if (source instanceof LocalDate) {
            LocalDate ld = (LocalDate)source;
            return ld.isBefore((LocalDate)target);
        }
        if (source instanceof LocalTime) {
            LocalTime lt = (LocalTime)source;
            return lt.isBefore((LocalTime)target);
        }
        return false;
    }

    public static int getAge(LocalDateTime birthDay) {
        LocalDateTime now = LocalDateTime.now();
        if (birthDay == null || birthDay.isAfter(now)) {
            throw new IllegalArgumentException("The birthDay is before Now. It's unbelievable!");
        }
        return (int)birthDay.until(now, ChronoUnit.YEARS);
    }

    public static String getBeforeByHourTime(int hour) {
        LocalDateTime ldt = LocalDateTime.now();
        ldt = ldt.minusHours(hour);
        return DateUtil.formatDateTime(ldt, null);
    }

    public static String getBeforeByDayTime(int day) {
        LocalDateTime now = LocalDateTime.now();
        now = now.minusDays(day);
        return DateUtil.formatDateTime(now, null);
    }

    public static Long getBeforeByDayLongTime(int day) {
        LocalDateTime now = LocalDateTime.now();
        now = now.minusDays(-day);
        return now.toEpochSecond(ZONE_BJ);
    }

    public static Long epochMilli(LocalDateTime ldt) {
        return DateUtil.epochMilli(ldt, ZONE_BJ);
    }

    public static Long epochMilli(LocalDateTime ldt, ZoneOffset offset) {
        if (ldt == null) {
            return 0L;
        }
        return ldt.toInstant(offset).toEpochMilli();
    }

    public static LocalDateTime toLdt(long milli) {
        return DateUtil.toLdt(milli, ZoneOffset.ofHours(8));
    }

    public static LocalDateTime ldt(long milli) {
        return DateUtil.toLdt(milli, ZoneOffset.ofHours(8));
    }

    public static LocalDateTime toLdt(long milli, ZoneId zoneId) {
        return Instant.ofEpochMilli(milli).atZone(zoneId).toLocalDateTime();
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        return DateUtil.formatDateTime(dateTime, YYYY_MM_DD_HH_MM_SS);
    }

    public static String formatDateTime(LocalDateTime dateTime, String pattern) {
        return DateUtil.format(Objects.toString(pattern, YYYY_MM_DD_HH_MM_SS), dateTime);
    }

    public static String formatDateTimeGmt(LocalDateTime localDateTime, String pattern) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.from(ZoneOffset.UTC));
        ZonedDateTime converted = zonedDateTime.withZoneSameInstant(ZoneId.of("GMT"));
        return DateTimeFormatter.ofPattern(pattern, Locale.US).format(converted);
    }

    public static String formatDate(LocalDate dateTime) {
        return DateUtil.formatDate(dateTime, YYYY_MM_DD);
    }

    public static String formatDate(LocalDate dateTime, String pattern) {
        return DateUtil.format(Objects.toString(pattern, YYYY_MM_DD), dateTime);
    }

    public static String formatTime(LocalTime dateTime) {
        return DateUtil.formatTime(dateTime, HH_MM_SS);
    }

    public static String formatTime(LocalTime dateTime, String pattern) {
        return DateUtil.format(Objects.toString(pattern, HH_MM_SS), dateTime);
    }

    private static String format(String pattern, TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        return DateUtil.formatter(pattern).format(temporal);
    }

    private static <T> T parse(String pattern, String input, TemporalQuery<T> query) {
        return DateUtil.formatter(pattern).parse((CharSequence)input, query);
    }

    public static DateTimeFormatter formatter(String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        Objects.requireNonNull(formatter, "formatter");
        return formatter;
    }

    public static List<String> getAllLds(String beginTime, String endTime) {
        LocalDate startDate = DateUtil.parseDate(beginTime);
        LocalDate endDate = DateUtil.parseDate(endTime);
        ArrayList<String> dates = new ArrayList<String>();
        while (!endDate.isBefore(startDate)) {
            dates.add(DateUtil.formatDate(startDate, null));
            startDate = startDate.plusDays(1L);
        }
        return dates;
    }

    public static LocalDateTime beginOrEndDateTime(LocalDateTime input, long amountToAdd, ChronoDate chrono, boolean begin) {
        if (input == null || chrono == null) {
            return null;
        }
        LocalDate localTime = input.toLocalDate();
        localTime = DateUtil.beginOrEndDate(localTime, amountToAdd, chrono, begin);
        return LocalDateTime.of(localTime, begin ? LocalTime.MIN : LocalTime.MAX);
    }

    public static LocalDate endDate(LocalDate input, ChronoDate chrono) {
        return DateUtil.beginOrEndDate(input, 0L, chrono, false);
    }

    public static LocalDate beginDate(LocalDate input, ChronoDate chrono) {
        return DateUtil.beginOrEndDate(input, 0L, chrono, true);
    }

    public static LocalDateTime ldtUtc(LocalDateTime dateTime, String utc) {
        if (StringUtils.isBlank((CharSequence)utc)) {
            return null;
        }
        ZonedDateTime zonedDateTime = dateTime.atZone(ZoneId.from(ZoneOffset.UTC));
        ZonedDateTime converted = zonedDateTime.withZoneSameInstant(ZoneOffset.of(utc));
        return converted.toLocalDateTime();
    }

    public static LocalDate beginOrEndDate(LocalDate input, long amountToAdd, ChronoDate chrono, boolean begin) {
        if (input == null || chrono == null) {
            return null;
        }
        TemporalAdjuster adjuster = null;
        ChronoUnit unit = null;
        switch (chrono) {
            case YEARS: {
                unit = ChronoUnit.YEARS;
                adjuster = begin ? TemporalAdjusters.firstDayOfYear() : TemporalAdjusters.lastDayOfYear();
                break;
            }
            case FIRST_HALF_YEAR: {
                unit = ChronoUnit.YEARS;
                adjuster = begin ? TemporalAdjusters.firstDayOfYear() : temporal -> temporal.with(ChronoField.DAY_OF_YEAR, 1L).plus(6L, ChronoUnit.MONTHS).plus(-1L, ChronoUnit.MONTHS);
                break;
            }
            case NEXT_HALF_YEAR: {
                unit = ChronoUnit.YEARS;
                adjuster = !begin ? TemporalAdjusters.lastDayOfYear() : temporal -> temporal.with(ChronoField.DAY_OF_YEAR, 1L).plus(6L, ChronoUnit.MONTHS);
                break;
            }
            case QUARTER: {
                unit = ChronoUnit.MONTHS;
                amountToAdd *= 3L;
                adjuster = temporal -> {
                    int month = temporal.get(ChronoField.MONTH_OF_YEAR);
                    int monthDiff = (begin ? 2 : 0) - (month + 2) % 3;
                    Temporal t = temporal.plus(monthDiff, ChronoUnit.MONTHS);
                    ValueRange range = t.range(ChronoField.DAY_OF_MONTH);
                    return t.with(ChronoField.DAY_OF_MONTH, begin ? range.getMinimum() : range.getMaximum());
                };
                break;
            }
            case MONTHS: {
                unit = ChronoUnit.MONTHS;
                adjuster = begin ? TemporalAdjusters.firstDayOfMonth() : TemporalAdjusters.lastDayOfMonth();
                break;
            }
            case WEEKS: {
                unit = ChronoUnit.WEEKS;
                adjuster = temporal -> {
                    int daysDiff = DayOfWeek.MONDAY.getValue() - temporal.get(ChronoField.DAY_OF_WEEK);
                    daysDiff = begin ? daysDiff : daysDiff + 6;
                    return temporal.plus(daysDiff, ChronoUnit.DAYS);
                };
                break;
            }
            case DAYS: {
                unit = ChronoUnit.DAYS;
                adjuster = temporal -> temporal;
                break;
            }
        }
        return input.plus(amountToAdd, unit).with(adjuster);
    }
}

