/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.suport.StandardMultipartFile;
import cn.sinozg.applet.common.utils.PojoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.Response;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final Map<String, String> MIME_TYPE = new HashMap<String, String>();
    private static final TikaConfig CONFIG = TikaConfig.getDefaultConfig();
    private static final Tika TIKA = new Tika(CONFIG);

    private FileUtil() {
    }

    public static File multipartFileToFile(MultipartFile multipartFile) {
        File file;
        if (multipartFile == null) {
            return null;
        }
        try {
            file = File.createTempFile("multipart_file", multipartFile.getOriginalFilename());
            file.deleteOnExit();
            FileUtils.writeByteArrayToFile((File)file, (byte[])multipartFile.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public static MultipartFile multipartFile(File file) {
        MultipartFile multipartFile;
        if (file == null) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            String contentType = FileUtil.fileType(file);
            multipartFile = FileUtil.multipartFile(fis, file.getName(), contentType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u8f6c MultipartFile \u5bf9\u8c61\u9519\u8bef\uff01", (Throwable)e);
                throw new CavException("BIZ000100028");
            }
        }
        fis.close();
        return multipartFile;
    }

    @Deprecated
    public static MultipartFile multipartFile(InputStream is, String fileName) {
        return FileUtil.multipartFile(is, fileName, null);
    }

    public static MultipartFile multipartFile(InputStream is, String fileName, String contentType) {
        DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(10240)).get();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = FileUtil.fileType(fileName);
        }
        DiskFileItem fi = ((DiskFileItem.Builder)((DiskFileItem.Builder)((DiskFileItem.Builder)((DiskFileItem.Builder)factory.fileItemBuilder().setFieldName("file_multipart")).setContentType(contentType)).setFormField(false)).setFileName(fileName)).get();
        try (OutputStream os = fi.getOutputStream();){
            FileUtil.writeBuffer(is, os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new StandardMultipartFile(fi, fileName);
    }

    public static void writeBuffer(InputStream is, OutputStream os) throws IOException {
        int bytesRead;
        int cacheLength = 8192;
        byte[] buffer = new byte[cacheLength];
        while ((bytesRead = is.read(buffer, 0, cacheLength)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
    }

    public static String fileType(String fileName) {
        Optional optional = MediaTypeFactory.getMediaType((String)fileName);
        return optional.orElse(MediaType.TEXT_PLAIN).toString();
    }

    public static boolean judgeFile(MultipartFile file, String ... arrays) {
        return FileUtil.judgeFile(FileUtil.multipartFileToFile(file), arrays);
    }

    public static String fileType(File file) {
        if (file == null || file.isDirectory()) {
            return null;
        }
        return FileUtil.tikaFileType(file);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean judgeFile(File file, String ... arrays) {
        if (ArrayUtils.isEmpty((Object[])arrays)) {
            return false;
        }
        String fileType = FileUtil.fileType(file);
        String extension = MIME_TYPE.get(fileType);
        if (StringUtils.isBlank((CharSequence)extension)) {
            log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a{}", (Object)fileType);
            return false;
        }
        for (String string : arrays) {
            void var7_7;
            if (!StringUtils.startsWith((CharSequence)string, (CharSequence)".")) {
                String string2 = "." + string;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)var7_7)) continue;
            return true;
        }
        log.error("\u89e3\u6790\u51fa\u6765\u7684\u6587\u4ef6\u683c\u5f0f\u4e3a\uff1a{}\uff0c\u8981\u5224\u65ad\u7684\u6587\u4ef6\u683c\u5f0f\u4e3a\uff1a{}", (Object)extension, (Object)arrays);
        return false;
    }

    public static String encodeName(String fileName, String charset) {
        try {
            if (StringUtils.isNotBlank((CharSequence)fileName)) {
                return URLEncoder.encode(fileName, charset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    public static String getHeaderFileName(Response response) {
        String[] strings;
        String dispositionHeader = response.header("Content-Disposition");
        if (StringUtils.isNotEmpty((CharSequence)dispositionHeader) && (strings = dispositionHeader.split(";")).length > 1) {
            dispositionHeader = strings[1].replace("filename=", "");
            dispositionHeader = dispositionHeader.replace("\"", "");
            return dispositionHeader.trim();
        }
        return "";
    }

    private static void initMimeType() {
        MimeTypes types = CONFIG.getMimeRepository();
        Object o = PojoUtil.getProperty((Object)types, "types");
        Map map = (Map)PojoUtil.cast(o);
        if (MapUtils.isNotEmpty((Map)map)) {
            for (Map.Entry e : map.entrySet()) {
                MIME_TYPE.put(((MimeType)e.getValue()).toString(), ((MimeType)e.getValue()).getExtension());
            }
        }
    }

    private static String tikaFileType(Object input) {
        String fileType = null;
        try {
            if (input instanceof File) {
                File f = (File)input;
                fileType = TIKA.detect(f);
            } else if (input instanceof InputStream) {
                InputStream is = (InputStream)input;
                fileType = TIKA.detect(is);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (MIME_TYPE.isEmpty()) {
            FileUtil.initMimeType();
        }
        return fileType;
    }
}

