/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.handler.SslSocket;
import cn.sinozg.applet.common.utils.FileUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final int READ_TIMEOUT = 10;
    private static final int WRITE_TIMEOUT = 30;
    private static final int CONNECT_TIMEOUT = 30;
    private static volatile OkHttpClient client = null;
    private static volatile OkHttpClient ssl_client = null;
    private static volatile OkHttpClient client302 = null;
    private static final int MAX_IDLE_CONNECTION = 5;
    private static final long KEEP_ALIVE_DURATION = 5L;
    private static final int IS_BODY = 1;
    private static final int IS_ARRAY = 2;
    private static final int IS_HEADER = 3;
    private static final int IS_FILE = 3;
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getInstance() {
        if (client != null) return client;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (client != null) return client;
            client = HttpUtil.build(false, true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient sslInstance() {
        if (ssl_client != null) return ssl_client;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (ssl_client != null) return ssl_client;
            ssl_client = HttpUtil.build(false, false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return ssl_client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getInstance302() {
        if (client302 != null) return client302;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (client302 != null) return client302;
            client302 = HttpUtil.build(true, true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return client302;
        }
    }

    public static String location302(String url, Map<String, String> headerMap) {
        Request.Builder builder = HttpUtil.builder(url, headerMap);
        Call call = HttpUtil.getInstance302().newCall(builder.get().build());
        Headers headers = (Headers)HttpUtil.responseBody(call, 3);
        if (headers != null) {
            return headers.get("Location");
        }
        return null;
    }

    public static byte[] getBytes(String url) {
        Call call = HttpUtil.baseGetCall(url, null);
        return (byte[])HttpUtil.responseBody(call, 2);
    }

    public static String doGet(String url) {
        return HttpUtil.doGet(url, null);
    }

    public static String doGet(String url, Map<String, String> headerMap) {
        Call call = HttpUtil.baseGetCall(url, headerMap);
        return (String)HttpUtil.responseBody(call, 1);
    }

    public static ImmutablePair<String, byte[]> getFile(String url, Map<String, String> headerMap) {
        Call call = HttpUtil.baseGetCall(url, headerMap);
        return (ImmutablePair)HttpUtil.responseBody(call, 3);
    }

    public static void doGetAsync(String url, Callback callback) {
        HttpUtil.doGetAsync(url, null, callback);
    }

    public static void doGetAsync(String url, Map<String, String> headerMap, Callback callback) {
        Call call = HttpUtil.baseGetCall(url, headerMap);
        call.enqueue(callback);
    }

    public static <T, R> T doPost(String url, Map<String, String> headerMap, R r, Class<T> clazz) {
        String jsonParams = JsonUtil.toJson(r);
        String result = HttpUtil.doPost(url, headerMap, jsonParams);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return JsonUtil.toPojo(result, clazz);
        }
        return null;
    }

    public static String doPost(String url, Map<String, String> mapParams) {
        return HttpUtil.doPost(url, null, mapParams);
    }

    public static String doPost(String url, Map<String, String> headerMap, Map<String, String> mapParams) {
        Call call = HttpUtil.basePostCallForm(url, headerMap, mapParams);
        return (String)HttpUtil.responseBody(call, 1);
    }

    public static String doPost(String url, Map<String, String> headerMap, String jsonParams) {
        Call call = HttpUtil.basePostCallJson(url, headerMap, jsonParams, false);
        return (String)HttpUtil.responseBody(call, 1);
    }

    public static String doPostJson(String url, Map<String, String> headerMap, String params) {
        Call call = HttpUtil.basePostCallJson(url, headerMap, params, true);
        return (String)HttpUtil.responseBody(call, 1);
    }

    public static String doPost(String url, String params) {
        return HttpUtil.doPost(url, null, params);
    }

    public static void doPostAsync(String url, Map<String, String> headerMap, Map<String, String> mapParams, Callback callback) {
        Call call = HttpUtil.basePostCallForm(url, headerMap, mapParams);
        call.enqueue(callback);
    }

    public static void doPostAsync(String url, Map<String, String> mapParams, Callback callback) {
        HttpUtil.doPostAsync(url, null, mapParams, callback);
    }

    public static void doPostAsync(String url, Map<String, String> headerMap, String jsonParams, Callback callback) {
        Call call = HttpUtil.basePostCallJson(url, headerMap, jsonParams, false);
        call.enqueue(callback);
    }

    public static void doPostAsync(String url, String jsonParams, Callback callback) {
        HttpUtil.doPostAsync(url, null, jsonParams, callback);
    }

    public static OkHttpClient build(boolean skipSsl, Consumer<OkHttpClient.Builder> c) {
        return HttpUtil.build(false, skipSsl, c);
    }

    private static OkHttpClient build(boolean redirects, boolean skipSsl) {
        return HttpUtil.build(redirects, skipSsl, null);
    }

    private static OkHttpClient build(boolean redirects, boolean skipSsl, Consumer<OkHttpClient.Builder> c) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().readTimeout(10L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(5, 5L, TimeUnit.MINUTES));
        if (redirects) {
            builder.followRedirects(false);
        }
        if (skipSsl) {
            X509TrustManager manager = SslSocket.trustManager();
            builder.sslSocketFactory(SslSocket.socketFactory(manager), manager).hostnameVerifier(SslSocket.hostnameVerifier());
        } else {
            ImmutablePair<SSLSocketFactory, X509TrustManager> pair = SslSocket.sslSocketFactory();
            if (pair != null) {
                builder.sslSocketFactory((SSLSocketFactory)pair.getKey(), (X509TrustManager)pair.getValue());
            }
        }
        if (c != null) {
            c.accept(builder);
        }
        return builder.build();
    }

    private static Call baseGetCall(String url, Map<String, String> headerMap) {
        Request request = HttpUtil.builder(url, headerMap).build();
        return HttpUtil.getInstance().newCall(request);
    }

    private static Call basePostCallForm(String url, Map<String, String> headerMap, Map<String, String> mapParams) {
        FormBody.Builder builder = new FormBody.Builder();
        if (mapParams != null) {
            for (String key : mapParams.keySet()) {
                builder.add(key, mapParams.get(key));
            }
        }
        Request.Builder requestBuilder = HttpUtil.builder(url, headerMap);
        requestBuilder.post((RequestBody)builder.build());
        Request request = requestBuilder.build();
        return HttpUtil.getInstance().newCall(request);
    }

    private static Call basePostCallJson(String url, Map<String, String> headerMap, String params, boolean isJson) {
        boolean jsonRequest = isJson || JsonUtil.isJson(params);
        MediaType type = jsonRequest ? MediaType.parse((String)"application/json") : MediaType.parse((String)"application/xml");
        assert (type != null);
        type.charset(Charset.defaultCharset());
        RequestBody body = RequestBody.Companion.create(params, type);
        Request.Builder requestBuilder = HttpUtil.builder(url, headerMap);
        requestBuilder.post(body);
        Request request = requestBuilder.build();
        return HttpUtil.getInstance().newCall(request);
    }

    private static Request.Builder builder(String url, Map<String, String> header) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (MapUtils.isNotEmpty(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T responseBody(Call call, int type) {
        try (Response response = call.execute();
             ResponseBody body = response.body();){
            Object result;
            if (body == null) return null;
            if (type == 1) {
                result = body.string();
            } else if (type == 2) {
                result = body.bytes();
            } else if (type == 3) {
                result = response.headers();
            } else {
                String fileName = FileUtil.getHeaderFileName(response);
                result = Pair.of((Object)fileName, (Object)body.bytes());
            }
            Object t = PojoUtil.cast(result);
            return t;
        }
        catch (Exception e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a", (Throwable)e);
        }
        return null;
    }
}

