/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.enums;

import cn.sinozg.applet.common.utils.DateUtil;

/**
 * 锁的粒度
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2023
 * @since 2023-08-24 15:14
 */
public enum LockGranularityType {

    /** 秒 */
    SECOND(DateUtil.YYYYMMDDHHMMSS),
    /** 分 */
    MINUTE(DateUtil.YYYYMMDDHHMM),
    /** 时 */
    HOUR(DateUtil.YYYYMMDDHH),
    /** 天 */
    DAY(DateUtil.YYYYMMDD),
    ;
    /** 格式 **/
    private final String pattern;

    LockGranularityType(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return pattern;
    }
}
