/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.enums;

/**
 * 自定义正则表达式验证枚举值
 * @Author: xyb
 * @Description:
 * @Date: 2023-09-29 下午 04:35
 **/
public enum RegexType {
    /** 手机号 <a href="https://github.com/VincentSit/ChinaMobilePhoneNumberRegex">开源地址</a> */
    MOBILE("手机号", "^(?:\\+?86)?1(?:3\\d{3}|5[^4\\D]\\d{2}|8\\d{3}|7(?:[235-8]\\d{2}|4(?:0\\d|1[0-2]|9\\d))|9[0-35-9]\\d{2}|66\\d{2})\\d{6}$"),
    /** 邮箱 */
    EMAIL("邮箱", "([\\w-]+(\\.[\\w-]+)*)@[\\w-]+(\\.[\\w-]+)+"),
    /** 身份证 */
    ID_CARD("身份证", "[1-6|8][0-7]\\d{4}(19|20)?\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}(\\d|x|X)?"),
    /** 邮政编码 */
    POSTAL ("邮政编码", "^[0-8][0-7]\\d{4}$"),
    /** 标志符字段 */
    FIELD("标志符字段", "^[a-z][a-zA-Z0-9_]+$"),

    ;


    /** 消息 */
    private final String msg;

    /** 正则表达式 */
    private final String regexp;

    RegexType(String msg, String regexp) {
        this.msg = msg;
        this.regexp = regexp;
    }

    public String getMsg() {
        return msg;
    }

    public String getRegexp() {
        return regexp;
    }
}