/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.handler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslSocket {
    public static List<String> CRT;
    private static final Logger LOG;

    public static ImmutablePair<SSLSocketFactory, X509TrustManager> sslSocketFactory() {
        if (CRT != null) {
            ArrayList<InputStream> iss = new ArrayList<InputStream>();
            try {
                for (String s : CRT) {
                    iss.add(Files.newInputStream(Paths.get(s, new String[0]), new OpenOption[0]));
                }
                return SslSocket.sslSocketFactory(iss);
            }
            catch (Exception e) {
                LOG.error("\u521b\u5efa\u8bc1\u4e66\u7684\u5de5\u5382\u9519\u8bef\uff01", (Throwable)e);
                throw new RuntimeException("Factory error in creating certificate!");
            }
        }
        return null;
    }

    public static ImmutablePair<SSLSocketFactory, X509TrustManager> sslSocketFactory(List<InputStream> ios) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            try {
                int i = 0;
                int size = ios.size();
                while (i < size) {
                    InputStream is = ios.get(i);
                    keyStore.setCertificateEntry(Integer.toString(i++), cf.generateCertificate(is));
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.error("\u8bfb\u53d6\u8bc1\u4e66\u6d41\u9519\u8bef\uff01", (Throwable)e);
                throw new RuntimeException("read certificate io error!");
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            SSLSocketFactory factory = sslContext.getSocketFactory();
            return ImmutablePair.of((Object)factory, (Object)SslSocket.sslTrustManager(keyStore));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLSocketFactory socketFactory(TrustManager manager) {
        SSLSocketFactory factory;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{manager}, new SecureRandom());
            factory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return factory;
    }

    public static X509TrustManager sslTrustManager(KeyStore keyStore) throws Exception {
        TrustManager trustManager;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        Object[] trustManagers = factory.getTrustManagers();
        if (trustManagers.length != 1 || !((trustManager = trustManagers[0]) instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        X509TrustManager tm = (X509TrustManager)trustManager;
        return tm;
    }

    public static X509TrustManager trustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public static HostnameVerifier hostnameVerifier() {
        return (s, sslSession) -> true;
    }

    static {
        LOG = LoggerFactory.getLogger(SslSocket.class);
    }
}

