/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.constant;

import com.fasterxml.jackson.databind.json.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * jackson 实例 web环境下初始化注入
 * 非web环境下 初始化
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 16:09
 */
public class OmConstants {
    private static final Logger LOG = LoggerFactory.getLogger(OmConstants.class);
    /** JsonMapper */
    private static volatile JsonMapper OM;

    /**
     * web方式注入
     * @param om 对象
     */
    public static void setOm(JsonMapper om){
        if (OM == null) {
            OM = om;
        }
    }

    /**
     * 获取实例
     * @return 实例
     */
    public static JsonMapper getOm() {
        if (OM == null) {
            synchronized (OmConstants.class) {
                if (OM == null) {
                    LOG.error("new 的对象。。。。。。");
                    OM = JsonMapper.builder().build();
                }
            }
        }
        return OM;
    }
}
