/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.enums;

import cn.sinozg.applet.common.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * 时间格式 自定义的支持配置
 * 自定义的会获取到用户的配置 设置到用户信息的 other-utcPattern
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-24 17:45
 */
public enum DatePattern {
    DATE_TIME_PATTERN(DateUtil.YYYY_MM_DD_HH_MM_SS),
    DATE_PATTERN (DateUtil.YYYY_MM_DD),
    YMD_PATTERN (DateUtil.YYYYMMDD),
    CUSTOMIZE (StringUtils.EMPTY),
    ;

    private final String pattern;

    DatePattern(String pattern) {
        this.pattern = pattern;
    }
    public String getPattern() {
        return pattern;
    }
}
