/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;


/**
 * 国际化
 * @Author: xyb
 * @Description:
 * @Date: 2023-05-04 上午 12:47
 **/
public class I18nName implements Serializable {

    /** 中文名称 */
    @JsonProperty(value = "zh")
    private String name;

    /** 英文名称 */
    @JsonProperty(value = "en")
    private String enName;

    /** 西班牙语 */
    @JsonProperty(value = "es")
    private String esName;

    /** 法语 */
    @JsonProperty(value = "fr")
    private String frName;

    /** 俄语 */
    @JsonProperty(value = "ru")
    private String ruName;

    /** 日语 */
    @JsonProperty(value = "ja")
    private String jaName;

    /**
     * 获取 中文名称
     *
     * @return name 中文名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置 中文名称
     *
     * @param name 中文名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取 英文名称
     *
     * @return enName 英文名称
     */
    public String getEnName() {
        return this.enName;
    }

    /**
     * 设置 英文名称
     *
     * @param enName 英文名称
     */
    public void setEnName(String enName) {
        this.enName = enName;
    }

    /**
     * 获取 西班牙语
     *
     * @return esName 西班牙语
     */
    public String getEsName() {
        return this.esName;
    }

    /**
     * 设置 西班牙语
     *
     * @param esName 西班牙语
     */
    public void setEsName(String esName) {
        this.esName = esName;
    }

    /**
     * 获取 法语
     *
     * @return frName 法语
     */
    public String getFrName() {
        return this.frName;
    }

    /**
     * 设置 法语
     *
     * @param frName 法语
     */
    public void setFrName(String frName) {
        this.frName = frName;
    }

    /**
     * 获取 俄语
     *
     * @return ruName 俄语
     */
    public String getRuName() {
        return ruName;
    }
    /**
     * 设置 俄语
     *
     * @param ruName 俄语
     */
    public void setRuName(String ruName) {
        this.ruName = ruName;
    }

    /**
     * 获取 日语
     *
     * @return jaName 日语
     */
    public String getJaName() {
        return this.jaName;
    }

    /**
     * 设置 日语
     *
     * @param jaName 日语
     */
    public void setJaName(String jaName) {
        this.jaName = jaName;
    }
}
