/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.enums;

/**
 * 数据字段
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2022-11-14 下午 09:38
*/
public enum DictType {
    /** 根 **/
    ROOT_TYPE("JB_ROOT"),

    /** 性别 **/
    GENDER("GENDER"),
    /** 数据操作状态 **/
    OPT_DATA_STATUS("OPT_DATA_STATUS"),
    /** 登录类型 **/
    LOGIN_TYPE("LOGIN_TYPE"),
    ;
    /** code */
    private final String code;

    DictType(String code) {
        this.code = code;
    }

    /**
     * 获取 code
     *
     * @return code code值
     */
    public String getCode() {
        return this.code;
    }

    public static DictType byCode (String code){
        for (DictType bt : DictType.values()) {
            if (bt.getCode().equals(code)) {
                return bt;
            }
        }
        return ROOT_TYPE;
    }
}
