/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.utils.AlgoUtil;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.NumberUtils;

public class CipherStrength {
    private static final int NUM = 1;
    private static final int SMALL_LETTER = 2;
    private static final int CAPITAL_LETTER = 3;
    private static final int OTHER_CHAR = 4;
    private static final int NUM_0 = 0;
    private static final int NUM_1 = 1;
    private static final int NUM_2 = 2;
    private static final int NUM_3 = 3;
    private static final int NUM_4 = 4;
    private static final int NUM_6 = 6;
    private static final int NUM_7 = 7;
    private static final int NUM_8 = 8;
    private static final int NUM_10 = 10;
    private static final int NUM_12 = 12;
    private static final int NUM_13 = 13;
    private static final int NUM_16 = 16;
    private static final int CHAR_0 = 48;
    private static final int CHAR_9 = 57;
    private static final int CHAR_A = 65;
    private static final int CHAR_Z = 90;
    private static final int CHAR_L_A = 97;
    private static final int CHAR_L_Z = 122;
    private static final String[] DICTIONARY = new String[]{"password", "abc123", "iloveyou", "adobe123", "123123", "sunshine", "1314520", "a1b2c3", "123qwe", "aaa111", "qweasd", "admin", "passwd"};

    private CipherStrength() {
    }

    public static int passwordStrength(String password) {
        int score;
        String nullString = "null";
        if (StringUtils.isBlank((CharSequence)password) || Strings.CI.equals(password, nullString)) {
            throw new IllegalArgumentException("password is empty");
        }
        int level = score = CipherStrength.lengthPassword(password);
        score = CipherStrength.combinationScore(password);
        level += score;
        score = CipherStrength.basePassword(password);
        level -= score;
        score = CipherStrength.sectionEqual(2, password);
        level -= score;
        score = CipherStrength.sectionEqual(3, password);
        level -= score;
        score = CipherStrength.datePassword(password);
        if (CipherStrength.isCharEqual(password) || (level -= score) < 3) {
            level = 0;
        }
        return level;
    }

    public static String passwordStrengthLevel(String password) {
        int level = CipherStrength.passwordStrength(password);
        if (level < 4) {
            return "EASY";
        }
        if (level < 7) {
            return "MEDIUM";
        }
        if (level < 10) {
            return "STRONG";
        }
        if (level < 13) {
            return "VERY_STRONG";
        }
        return "EXTREMELY_STRONG";
    }

    public static boolean weakPassword(String password) {
        int level = CipherStrength.passwordStrength(password);
        return level < 7;
    }

    private static int checkCharacterType(char c) {
        if (c >= '0' && c <= '9') {
            return 1;
        }
        if (c >= 'A' && c <= 'Z') {
            return 3;
        }
        if (c >= 'a' && c <= 'z') {
            return 2;
        }
        return 4;
    }

    private static int countLetter(String password, int type) {
        int count = 0;
        if (StringUtils.isNotBlank((CharSequence)password)) {
            char[] arrays;
            for (char c : arrays = password.toCharArray()) {
                if (CipherStrength.checkCharacterType(c) != type) continue;
                ++count;
            }
        }
        return count;
    }

    private static int combinationScore(String password) {
        int score = 0;
        int len = password.length();
        if (len > 4 && CipherStrength.countLetter(password, 3) > 0) {
            ++score;
        }
        if (len > 6 && CipherStrength.countLetter(password, 4) > 0) {
            ++score;
        }
        if (len > 4 && CipherStrength.combination(password, 2, 0, null)) {
            ++score;
        }
        if (len > 6 && CipherStrength.combination(password, 3, 0, null)) {
            ++score;
        }
        if (len > 8 && CipherStrength.combination(password, 4, 0, null)) {
            ++score;
        }
        if (len > 6 && CipherStrength.combination(password, 2, 3, 2)) {
            ++score;
        }
        if (len > 8 && CipherStrength.combination(password, 3, 2, null)) {
            ++score;
        }
        if (len > 10 && CipherStrength.combination(password, 4, 2, null)) {
            ++score;
        }
        return score;
    }

    private static boolean combination(String password, int combinationNum, int standardNum, Integer otherNum) {
        List<List<Integer>> combination;
        if (otherNum == null) {
            otherNum = standardNum;
        }
        if (CollectionUtils.isEmpty(combination = AlgoUtil.c(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), combinationNum))) {
            return true;
        }
        for (List<Integer> list : combination) {
            boolean temp = true;
            for (Integer i : list) {
                temp &= CipherStrength.countLetter(password, i) > (i == 4 ? otherNum : standardNum);
            }
            if (!temp) continue;
            return temp;
        }
        return false;
    }

    private static int lengthPassword(String password) {
        int length;
        int score = 0;
        if (CipherStrength.countLetter(password, 1) > 0) {
            ++score;
        }
        if (CipherStrength.countLetter(password, 2) > 0) {
            ++score;
        }
        if (CipherStrength.countLetter(password, 4) >= 3) {
            ++score;
        }
        if (CipherStrength.countLetter(password, 4) >= 6) {
            ++score;
        }
        if ((length = password.length()) > 12) {
            ++score;
        }
        if (length >= 16) {
            ++score;
        }
        if (length <= 6) {
            --score;
        }
        if (length <= 4) {
            --score;
        }
        return score;
    }

    private static int basePassword(String password) {
        String[] keyboard;
        int score = 0;
        String[] letter = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"};
        if (CipherStrength.indexOf(password, letter)) {
            ++score;
        }
        if (CipherStrength.indexOf(password, keyboard = new String[]{"qwertyuiop", "asdfghjkl", "zxcvbnm"})) {
            ++score;
        }
        String[] digits = new String[]{"01234567890", "09876543210"};
        if (NumberUtils.isDigits((String)password) && CipherStrength.indexOf(password, digits)) {
            ++score;
        }
        int len = password.length();
        if (CipherStrength.countLetter(password, 1) == len || CipherStrength.countLetter(password, 2) == len || CipherStrength.countLetter(password, 3) == len) {
            ++score;
        }
        for (String s : DICTIONARY) {
            if (!password.equals(s) && !s.contains(password) && !password.contains(s)) continue;
            --score;
            break;
        }
        return score;
    }

    private static int datePassword(String password) {
        int length = password.length();
        boolean isDate = false;
        if (NumberUtils.isDigits((String)password) && length >= 6) {
            String pattern = length == 8 ? "yyyyMMdd" : "yyMMdd";
            isDate = Boolean.TRUE.equals(TirsciUtil.tryCatch(() -> {
                DateUtil.parseDate(password, pattern);
                return true;
            }));
        }
        return isDate ? 1 : 0;
    }

    public static int sectionEqual(int sectionNum, String password) {
        int level = 0;
        if (password.length() % sectionNum != 0) {
            return level;
        }
        int div = password.length() / sectionNum;
        if (div == 1) {
            return level;
        }
        boolean sectionEqual = false;
        boolean charEqual = false;
        for (int i = 0; i < sectionNum - 1; ++i) {
            String part1 = password.substring(i * div, (i + 1) * div);
            String part2 = password.substring((i + 1) * div, (i + 2) * div);
            sectionEqual = part1.equals(part2);
            charEqual = CipherStrength.isCharEqual(part1) && CipherStrength.isCharEqual(part2);
        }
        if (sectionEqual) {
            ++level;
        }
        if (charEqual) {
            ++level;
        }
        return level;
    }

    private static boolean indexOf(String password, String[] resources) {
        for (String r : resources) {
            if (r.indexOf(password) <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isCharEqual(String str) {
        return str.replace(str.charAt(0), ' ').trim().isEmpty();
    }
}

