/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.enums;

import java.time.Duration;

/**
 * 限流模式单位
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-14 11:30
 */
public enum RateLimiterUnit {
    /** 秒 */
    SECONDS {
        @Override
        public Duration duration(int value) {
            return Duration.ofSeconds(value);
        }
    },
    /** 分 */
    MINUTES {
        @Override
        public Duration duration(int value) {
            return Duration.ofMinutes(value);
        }
    },
    /** 时 */
    HOURS {
        @Override
        public Duration duration(int value) {
            return Duration.ofHours(value);
        }
    },
    /** 天 */
    DAYS {
        @Override
        public Duration duration(int value) {
            return Duration.ofDays(value);
        }
    };
    RateLimiterUnit(){
    }

    public abstract Duration duration(int value);
}
