/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ArithUtil {
    private static final int DEF_DIV_SCALE = 10;
    private static final int ZERO = 0;

    private ArithUtil() {
    }

    public static double add(double ... ds) {
        BigDecimal bd = new BigDecimal(0);
        for (double d : ds) {
            bd = bd.add(new BigDecimal(Double.toString(d)));
        }
        return bd.doubleValue();
    }

    public static double sub(double ... ds) {
        BigDecimal bd = new BigDecimal(String.valueOf(ds[0]));
        int t = ds.length;
        for (int i = 1; i < t; ++i) {
            bd = bd.subtract(new BigDecimal(Double.toString(ds[i])));
        }
        return bd.doubleValue();
    }

    public static double mul(double ... ds) {
        BigDecimal bd = BigDecimal.ONE;
        for (double d : ds) {
            bd = bd.multiply(new BigDecimal(Double.toString(d)));
        }
        return bd.doubleValue();
    }

    public static double div(double ... ds) {
        return ArithUtil.div(10, ds);
    }

    public static double div(int scale, double ... ds) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u9700\u8981\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u4ee5\u540e\u51e0\u4f4d\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        int t = ds.length;
        BigDecimal bd = BigDecimal.valueOf(ds[0]);
        for (int i = 1; i < t; ++i) {
            if (ds[i] == 0.0) {
                return 0.0;
            }
            bd = bd.divide(BigDecimal.valueOf(ds[i]), scale, RoundingMode.HALF_DOWN);
        }
        return bd.doubleValue();
    }

    public static double round(double v, int scale) {
        return ArithUtil.round(v, scale, RoundingMode.HALF_UP);
    }

    public static double round(double v, int scale, RoundingMode roundingMode) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u9700\u8981\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u4ee5\u540e\u51e0\u4f4d\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (roundingMode == null) {
            throw new IllegalArgumentException("\u5904\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        BigDecimal b = BigDecimal.valueOf(v);
        return b.divide(BigDecimal.ONE, scale, roundingMode).doubleValue();
    }
}

