/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.instruct.model;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-22 12:41
 */
public class InstructFieldCache {
    @Schema(description = "是否有未知")
    private boolean unknown;
    @Schema(description = "结构体")
    private List<InstructFieldDetail> details;

    public InstructFieldCache (boolean unknown, List<InstructFieldDetail> details){
        this.unknown = unknown;
        this.details = details;
    }
    public boolean isUnknown() {
        return unknown;
    }

    public void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }

    public List<InstructFieldDetail> getDetails() {
        return details;
    }

    public void setDetails(List<InstructFieldDetail> details) {
        this.details = details;
    }
}
