/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.instruct.annotate;

import cn.sinozg.applet.common.utils.DateUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 指令协议 字段注解
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-09-28 12:38
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface InstructField {
    /** 开始位置 默认-1 不需要指定 */
    int begin() default -1;
    /** 字节位数 -1 表示 未知*/
    int bs() default -1;
    /** 到设备是十六进制，显示是十进制 */
    boolean decimalHex() default false;
    /** 到设备是十六进制，显示是十进制 浮点数 BigDecimal 接收 */
    boolean floatHex() default false;
    /** 转小数或者整数时候的系数，10的幂次 BigDecimal 接收 */
    int ratio() default 0;
    /** 小数点保留位数 BigDecimal 接收 */
    int scale() default Integer.MAX_VALUE;
    /** 字符串于 ascii 互转 */
    boolean ascii() default false;
    /** 将字符串 按照字节反转 */
    boolean revert() default false;
    /** 十六进制转二进制 */
    boolean hexToBinary() default false;
    /** 十六进制转二进制再截取后转十进制 */
    int[] hexToBinInt() default {};
    /** 字符串与日期之间的转化 */
    String pattern() default DateUtil.HHMMSS;
    /** 排序 */
    int sort() default Integer.MAX_VALUE;
}
