/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.instruct.util;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.instruct.annotate.InstructField;
import cn.sinozg.applet.instruct.model.InstructFieldCache;
import cn.sinozg.applet.instruct.model.InstructFieldDetail;
import cn.sinozg.applet.instruct.util.CodecUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructUtil {
    private static final int TWO = 2;
    private static final Map<Class<?>, InstructFieldCache> STRUCTURE_MAP = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(InstructUtil.class);

    public static <T> void decodeInstruct(String instruct, T t) {
        InstructUtil.decodeInstruct(instruct, t, true);
    }

    public static <T> void decodeInstruct(String instruct, T t, boolean reverse) {
        InstructFieldCache cache = InstructUtil.structureInfo(t.getClass(), reverse);
        List<InstructFieldDetail> structureList = cache.getDetails();
        if (cache.isUnknown()) {
            int unknownLength = StringUtils.length((CharSequence)instruct);
            for (InstructFieldDetail d : structureList) {
                if (d.isUnknown()) continue;
                unknownLength -= d.getBs() * 2;
            }
            structureList = InstructUtil.unknownStructure(structureList, unknownLength / 2);
        }
        try {
            InstructUtil.itemDecodeField(structureList, t, instruct);
        }
        catch (Exception e) {
            log.error("\u89e3\u7801\u9519\u8bef\uff0c\uff0c\uff0c", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> String encodedInstruct(T t) {
        return InstructUtil.encodedInstruct(t, true);
    }

    public static <T> String encodedInstruct(T t, boolean reverse) {
        List<InstructFieldDetail> structureList = InstructUtil.structureInfo(t.getClass(), reverse).getDetails();
        StringBuilder instruct = new StringBuilder();
        try {
            InstructUtil.itemEncodeField(structureList, t, instruct);
        }
        catch (Exception e) {
            log.error("\u7f16\u7801\u9519\u8bef\uff0c\uff0c\uff0c", (Throwable)e);
            throw new RuntimeException(e);
        }
        return instruct.toString();
    }

    public static void itemDecodeField(List<InstructFieldDetail> list, Object o, String instruct) throws Exception {
        for (InstructFieldDetail d : list) {
            Object v;
            Field field = d.getField();
            field.setAccessible(true);
            if (CollectionUtils.isNotEmpty(d.getDetails())) {
                v = PojoUtil.newInstance(d.getType());
                InstructUtil.itemDecodeField(d.getDetails(), v, instruct);
            } else {
                v = d.getBs() == 0 ? "" : InstructUtil.decodeField(instruct, field, d);
            }
            field.set(o, v);
        }
    }

    private static void itemEncodeField(List<InstructFieldDetail> list, Object o, StringBuilder instruct) throws Exception {
        for (InstructFieldDetail d : list) {
            Field field = d.getField();
            field.setAccessible(true);
            Object value = field.get(o);
            if (CollectionUtils.isNotEmpty(d.getDetails())) {
                List subs = (List)PojoUtil.cast((Object)value);
                for (Object sub : subs) {
                    InstructUtil.itemEncodeField(d.getDetails(), sub, instruct);
                }
                continue;
            }
            String v = InstructUtil.encodeField(field, value, d);
            instruct.append(v);
        }
    }

    private static Object decodeField(String instruct, Field field, InstructFieldDetail d) {
        String s = StringUtils.substring((String)instruct, (int)d.getBegin(), (int)(d.getBegin() + 2 * d.getBs()));
        return InstructUtil.decode(s, field, d);
    }

    public static Object decode(String s, Field field, InstructFieldDetail d) {
        int[] hexToBinInt;
        Integer[] v = s;
        if (d.isRevert()) {
            v = CodecUtil.revertStrLen2(s);
        }
        if (field.getType() == LocalDateTime.class) {
            v = CodecUtil.ldtTime(s, d.getPattern());
        }
        if (d.isDecimalHex()) {
            v = CodecUtil.hexToInt(s);
        }
        if (d.isAscii()) {
            v = CodecUtil.asciiToString(s);
        }
        if (d.isFloatHex()) {
            float f = CodecUtil.hexToFloat(s);
            v = new BigDecimal(f);
        }
        if (d.getRatio() != null) {
            BigDecimal bg = new BigDecimal(String.valueOf(v));
            BigDecimal ratio = BigDecimal.valueOf(Math.pow(10.0, d.getRatio().intValue()));
            v = bg.multiply(ratio);
        }
        if (d.getScale() != null) {
            BigDecimal bg = new BigDecimal(String.valueOf(v));
            v = bg.setScale((int)d.getScale(), RoundingMode.HALF_UP);
        }
        if (d.isHexToBinary()) {
            v = CodecUtil.hexToBinary(s, d.getBs());
        }
        if (ArrayUtils.isNotEmpty((int[])(hexToBinInt = d.getHexToBinInt()))) {
            String bin = CodecUtil.hexToBinary(s, d.getBs());
            Integer[] binInt = new Integer[hexToBinInt.length];
            int index = bin.length();
            for (int i = 0; i < hexToBinInt.length; ++i) {
                binInt[i] = CodecUtil.binaryToInt(bin.substring(index - hexToBinInt[i], index));
                index -= hexToBinInt[i];
            }
            v = binInt;
        }
        return v;
    }

    private static String encodeField(Field field, Object data, InstructFieldDetail d) {
        int[] hexToBinInt;
        String fv = null;
        if (field.getType() == LocalDateTime.class) {
            fv = CodecUtil.ldtTime((LocalDateTime)data, d.getPattern());
        }
        if (d.isDecimalHex() && data instanceof Integer) {
            Integer i = (Integer)data;
            fv = CodecUtil.intToHex(i, d.getBs());
        }
        if (d.isAscii()) {
            fv = CodecUtil.stringToAscii(String.valueOf(data));
        }
        if (d.isHexToBinary() && data instanceof Byte) {
            Byte b = (Byte)data;
            fv = CodecUtil.byteToHex(b, d.getBs());
        }
        if (fv == null) {
            fv = CodecUtil.leftPad(String.valueOf(data), d.getBs());
        }
        if (ArrayUtils.isNotEmpty((int[])(hexToBinInt = d.getHexToBinInt()))) {
            Integer[] binInt = (Integer[])PojoUtil.cast((Object)data);
            StringBuilder bin = new StringBuilder();
            for (int i = 0; i < hexToBinInt.length; ++i) {
                bin.insert(0, CodecUtil.intToBin(binInt[i], hexToBinInt[i]));
            }
            fv = CodecUtil.binaryToHex(bin.toString());
        }
        return fv;
    }

    public static List<InstructFieldDetail> structureInfo(Class<?> clazz) {
        return InstructUtil.structureInfo(clazz, true).getDetails();
    }

    public static InstructFieldCache structureInfo(Class<?> clazz, boolean reverse) {
        if (!STRUCTURE_MAP.containsKey(clazz)) {
            List fields = PojoUtil.allField(clazz, (boolean)reverse);
            ArrayList<InstructFieldDetail> list = new ArrayList<InstructFieldDetail>();
            int begin = 0;
            boolean unknown = false;
            int j = fields.size();
            for (int i = 0; i < j; ++i) {
                Field field = (Field)fields.get(i);
                InstructField insField = field.getAnnotation(InstructField.class);
                if (insField == null) continue;
                InstructFieldDetail detail = new InstructFieldDetail(field, i, begin, insField);
                begin = detail.getBegin() + detail.getBs() * 2;
                if (!unknown && detail.isUnknown()) {
                    unknown = true;
                }
                list.add(detail);
            }
            list.sort(Comparator.comparingInt(InstructFieldDetail::getIndex));
            STRUCTURE_MAP.put(clazz, new InstructFieldCache(unknown, list));
        }
        return STRUCTURE_MAP.get(clazz);
    }

    public static List<InstructFieldDetail> unknownStructure(List<InstructFieldDetail> list, int bs) {
        List structure = PojoUtil.copyList(list, InstructFieldDetail.class);
        for (InstructFieldDetail d : structure) {
            if (!d.isUnknown()) continue;
            d.setBs(bs);
        }
        int begin = 0;
        for (InstructFieldDetail d : structure) {
            d.setBegin(begin);
            begin = d.getBegin() + d.getBs() * 2;
        }
        return structure;
    }
}

