/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.instruct.model;

import cn.sinozg.applet.instruct.annotate.InstructField;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;

/**
 * 指令解析字段详情
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-09-28 12:39
 */
public class InstructFieldDetail implements Serializable {

    @Schema(description = "字段属性")
    private Field field;

    @Schema(description = "十六进制转十进制")
    private boolean decimalHex;

    @Schema(description = "十六进制转十进制 浮点数")
    private boolean floatHex;

    @Schema(description = "系数指数")
    private Integer ratio;

    @Schema(description = "小数 保留位数")
    private Integer scale;

    @Schema(description = "十六进制转二进制")
    private boolean hexToBinary;

    @Schema(description = "ascii转字符串")
    private boolean ascii;

    @Schema(description = "反转")
    private boolean revert;

    @Schema(description = "下标")
    private int index;

    @Schema(description = "开始下标")
    private int begin;

    @Schema(description = "字节数")
    private int bs;

    @Schema(description = "十六进制转二进制再截取后转十进制")
    private int[] hexToBinInt;

    @Schema(description = "是否数组")
    private boolean isArray;

    @Schema(description = "子数据")
    private List<InstructFieldDetail> details;

    @Schema(description = "子协议的时候的对象类型")
    private Class<?> type;

    @Schema(description = "时间格式")
    private String pattern;

    public InstructFieldDetail (){}

    public InstructFieldDetail(Field field, int index, int begin, InstructField info){
        this.field = field;
        this.index = index;
        if (info.sort() != Integer.MAX_VALUE) {
            this.index = info.sort();
        }
        this.begin = info.begin() == -1 ? begin : info.begin();
        this.bs = info.bs();
        this.floatHex = info.floatHex();
        this.ratio = info.ratio() == 0 ? null : info.ratio();
        this.scale = info.scale() == Integer.MAX_VALUE ? null : info.scale();
        this.hexToBinary = info.hexToBinary();
        this.decimalHex = info.decimalHex();
        this.hexToBinInt = info.hexToBinInt();
        this.revert = info.revert();
        this.ascii = info.ascii();
        this.pattern = info.pattern();
    }

    public boolean isUnknown() {
        return bs == -1;
    }

    public Field getField() {
        return field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean isDecimalHex() {
        return decimalHex;
    }

    public void setDecimalHex(boolean decimalHex) {
        this.decimalHex = decimalHex;
    }

    public boolean isFloatHex() {
        return floatHex;
    }

    public void setFloatHex(boolean floatHex) {
        this.floatHex = floatHex;
    }

    public Integer getRatio() {
        return ratio;
    }

    public void setRatio(Integer ratio) {
        this.ratio = ratio;
    }

    public Integer getScale() {
        return scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public boolean isHexToBinary() {
        return hexToBinary;
    }

    public void setHexToBinary(boolean hexToBinary) {
        this.hexToBinary = hexToBinary;
    }

    public boolean isAscii() {
        return ascii;
    }

    public void setAscii(boolean ascii) {
        this.ascii = ascii;
    }

    public boolean isRevert() {
        return revert;
    }

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getBegin() {
        return begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getBs() {
        return bs;
    }

    public void setBs(int bs) {
        this.bs = bs;
    }

    public int[] getHexToBinInt() {
        return hexToBinInt;
    }

    public void setHexToBinInt(int[] hexToBinInt) {
        this.hexToBinInt = hexToBinInt;
    }

    public boolean isArray() {
        return isArray;
    }

    public void setArray(boolean array) {
        isArray = array;
    }

    public List<InstructFieldDetail> getDetails() {
        return details;
    }

    public void setDetails(List<InstructFieldDetail> details) {
        this.details = details;
    }

    public Class<?> getType() {
        return type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}
