/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.instruct.util;

import cn.sinozg.applet.common.utils.DateUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecUtil {
    private static final int TWO = 2;
    private static final String[] HM = new String[]{"HH", "mm"};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Logger log = LoggerFactory.getLogger(CodecUtil.class);

    public static LocalDateTime ldtTime(String input, String pattern) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{input, pattern})) {
            return null;
        }
        if (Strings.CS.startsWithAny((CharSequence)pattern, (CharSequence[])HM)) {
            LocalTime lt = DateUtil.parseTime((String)input, (String)pattern);
            LocalDate ld = LocalDate.now();
            if (lt.isAfter(LocalTime.now())) {
                ld = ld.minusDays(1L);
            }
            return ld.atTime(lt);
        }
        return DateUtil.parseDateTime((String)input, (String)pattern);
    }

    public static String ldtTime(LocalDateTime input, String pattern) {
        if (input == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pattern})) {
            return null;
        }
        if (Strings.CS.startsWithAny((CharSequence)pattern, (CharSequence[])HM)) {
            return DateUtil.formatTime((LocalTime)input.toLocalTime(), (String)pattern);
        }
        return DateUtil.formatDateTime((LocalDateTime)input, (String)pattern);
    }

    public static int hexToInt(String hex) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)hex)) {
            try {
                BigInteger bi = new BigInteger(hex, 16);
                result = bi.intValue();
            }
            catch (Exception e) {
                log.error("\u5341\u516d\u8fdb\u5236\u8f6c\u5341\u8fdb\u5236\u9519\u8bef\uff1a" + hex, (Throwable)e);
            }
        }
        return result;
    }

    private static String intToHex(int input) {
        return Integer.toHexString(input);
    }

    public static String intToHex(int input, int bs) {
        return CodecUtil.leftPad(CodecUtil.intToHex(input), bs * 2);
    }

    public static String intToBin(int input, int len) {
        String bin = Integer.toBinaryString(input);
        return CodecUtil.leftPad(bin, len);
    }

    public static float hexToFloat(String input) {
        byte[] byteArray = new byte[4];
        int i = 0;
        int j = 0;
        while (i < input.length()) {
            byteArray[j] = (byte)Integer.parseInt(input.substring(i, i + 2), 16);
            i += 2;
            ++j;
        }
        return ByteBuffer.wrap(byteArray).getFloat();
    }

    public static String asciiToString(String ascii) {
        StringBuilder sbu = new StringBuilder();
        for (int i = 0; i < ascii.length(); i += 2) {
            sbu.append((char)CodecUtil.hexToInt(ascii.substring(i, i + 2)));
        }
        return sbu.toString();
    }

    public static String stringToAscii(String message) {
        char[] chars;
        StringBuilder sbu = new StringBuilder();
        for (char c : chars = message.toCharArray()) {
            sbu.append(CodecUtil.intToHex(c));
        }
        return sbu.toString();
    }

    public static String hexToBinary(String input, int bs) {
        int t = CodecUtil.hexToInt(input);
        return CodecUtil.leftPad(Integer.toBinaryString(t), bs * 8);
    }

    public static String binaryToHex(String binary) {
        int t = Integer.parseInt(binary, 2);
        return Integer.toHexString(t);
    }

    public static String byteToHex(byte input) {
        return CodecUtil.byteToHex(input, 2);
    }

    public static String byteToHex(byte input, int bs) {
        String format = "%0" + bs + "X";
        return String.format(format, input);
    }

    public static String leftPad(String input, int length) {
        return StringUtils.leftPad((String)input, (int)length, (String)"0");
    }

    public static String toHexString(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        for (byte aByte : bytes) {
            sb.append(HEX[(aByte & 0xF0) >> 4]).append(HEX[aByte & 0xF]);
        }
        return sb.toString();
    }

    public static Integer binaryToInt(String input) {
        return Integer.parseInt(input, 2);
    }

    public static String revertStrLen2(String input) {
        if (StringUtils.isBlank((CharSequence)input) || input.length() % 2 != 0) {
            return input;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = input.length() - 2; i >= 0; i -= 2) {
            list.add(input.substring(i, i + 2));
        }
        return StringUtils.join(list, (String)"");
    }
}

