/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.quartz.use.scheduler;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.function.BiConsumerException;
import cn.sinozg.applet.common.function.ConsumerException;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.quartz.use.enums.JobKeyEnum;
import cn.sinozg.applet.quartz.use.enums.JobOptEnum;
import cn.sinozg.applet.quartz.use.enums.JobTypeEnum;
import cn.sinozg.applet.quartz.use.ext.DailyTimeIntervalMonthScheduleBuilder;
import cn.sinozg.applet.quartz.use.handler.JobHandlerInvoker;
import cn.sinozg.applet.quartz.use.module.SchedulerBaseParams;
import cn.sinozg.applet.quartz.use.module.SchedulerCronParams;
import cn.sinozg.applet.quartz.use.module.SchedulerCycleOnceParams;
import cn.sinozg.applet.quartz.use.module.SchedulerCycleTimesParams;
import cn.sinozg.applet.quartz.use.module.TaskScheduleModel;
import cn.sinozg.applet.quartz.use.util.CronUtils;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerManager {
    private static final Logger log = LoggerFactory.getLogger(SchedulerManager.class);
    private final Scheduler scheduler;

    public SchedulerManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public <T extends SchedulerBaseParams> void addJob(T params) {
        this.validateScheduler();
        String beanName = params.getBeanName();
        JobDetail jobDetail = JobBuilder.newJob(JobHandlerInvoker.class).usingJobData(JobKeyEnum.JOB_ID.name(), params.getId()).usingJobData(JobKeyEnum.JOB_TENANT.name(), params.getTenantId()).usingJobData(JobKeyEnum.JOB_NAME.name(), params.getJobName()).usingJobData(JobKeyEnum.JOB_BEAN_NAME.name(), beanName).withIdentity(beanName).build();
        Trigger trigger = this.buildTrigger(params);
        this.schedulerRun(jobDetail, trigger, JobOptEnum.ADD, (arg_0, arg_1) -> ((Scheduler)this.scheduler).scheduleJob(arg_0, arg_1));
    }

    public <T extends SchedulerBaseParams> void updateJob(T params) {
        this.validateScheduler();
        Trigger trigger = this.buildTrigger(params);
        this.schedulerRun(new TriggerKey(params.getId()), trigger, JobOptEnum.UPDATE, (arg_0, arg_1) -> ((Scheduler)this.scheduler).rescheduleJob(arg_0, arg_1));
    }

    public void deleteJob(String id) {
        this.validateScheduler();
        this.schedulerRun(new JobKey(id), JobOptEnum.DEL, arg_0 -> ((Scheduler)this.scheduler).deleteJob(arg_0));
    }

    public void pauseJob(String id) {
        this.validateScheduler();
        this.schedulerRun(new JobKey(id), JobOptEnum.PAUSE, arg_0 -> ((Scheduler)this.scheduler).pauseJob(arg_0));
    }

    public void resumeJob(String id) {
        this.validateScheduler();
        this.schedulerRun(new JobKey(id), JobOptEnum.RESUME, arg_0 -> ((Scheduler)this.scheduler).resumeJob(arg_0));
        this.schedulerRun(new TriggerKey(id), JobOptEnum.RESUME, arg_0 -> ((Scheduler)this.scheduler).resumeTrigger(arg_0));
    }

    public <T extends SchedulerBaseParams> void triggerJob(T params) {
        this.validateScheduler();
        JobDataMap data = new JobDataMap();
        String beanName = params.getBeanName();
        data.put(JobKeyEnum.JOB_ID.name(), params.getId());
        data.put(JobKeyEnum.JOB_TENANT.name(), params.getTenantId());
        data.put(JobKeyEnum.JOB_BEAN_NAME.name(), beanName);
        data.put(JobKeyEnum.JOB_ARGS.name(), params.getArgs());
        this.schedulerRun(new JobKey(beanName), data, JobOptEnum.RESUME, (arg_0, arg_1) -> ((Scheduler)this.scheduler).triggerJob(arg_0, arg_1));
    }

    private <T extends SchedulerBaseParams> Trigger buildTrigger(T params) {
        CronScheduleBuilder schedule;
        if (params instanceof SchedulerCycleTimesParams) {
            SchedulerCycleTimesParams timesParams = (SchedulerCycleTimesParams)params;
            schedule = this.dailyBuilder(timesParams);
        } else {
            String cron;
            if (params instanceof SchedulerCronParams) {
                SchedulerCronParams p = (SchedulerCronParams)params;
                cron = p.getCron();
            } else {
                SchedulerCycleOnceParams p = (SchedulerCycleOnceParams)params;
                TaskScheduleModel model = new TaskScheduleModel();
                model.setJobType(JobTypeEnum.MONTH);
                model.setDayOfMonths(p.getRunDays());
                LocalTime time = p.getRunTime();
                model.setHour(time.getHour());
                model.setMinute(time.getMinute());
                model.setSecond(time.getSecond());
                cron = CronUtils.cronExpression(model);
            }
            schedule = CronScheduleBuilder.cronSchedule((String)cron);
        }
        return this.buildTrigger((ScheduleBuilder<T>)schedule, params);
    }

    private ScheduleBuilder<? extends Trigger> dailyBuilder(SchedulerCycleTimesParams params) {
        Object schedule = null;
        Integer[] days = null;
        TimeOfDay startingDailyAt = null;
        TimeOfDay endingDailyAt = null;
        LocalTime lt = params.getBeginTime();
        if (lt != null) {
            startingDailyAt = TimeOfDay.hourMinuteAndSecondOfDay((int)lt.getHour(), (int)lt.getMinute(), (int)lt.getSecond());
        }
        if ((lt = params.getEndTime()) != null) {
            endingDailyAt = TimeOfDay.hourMinuteAndSecondOfDay((int)lt.getHour(), (int)lt.getMinute(), (int)lt.getSecond());
        }
        DateBuilder.IntervalUnit unit = DateBuilder.IntervalUnit.HOUR;
        if ("01".equals(params.getIntervalUnit())) {
            unit = DateBuilder.IntervalUnit.SECOND;
        } else if ("02".equals(params.getIntervalUnit())) {
            unit = DateBuilder.IntervalUnit.MINUTE;
        }
        if (CollectionUtils.isNotEmpty(params.getRunDays()) && !params.getRunDays().contains(0)) {
            days = (Integer[])PojoUtil.toArray(params.getRunDays(), Integer.class);
            if ("02".equals(params.getJobType())) {
                schedule = DailyTimeIntervalMonthScheduleBuilder.dailyTimeIntervalSchedule().startingDailyAt(startingDailyAt).endingDailyAt(endingDailyAt).withInterval(params.getIntervalTime(), unit).onDaysOfTheMonth(days);
            }
        }
        if (schedule == null) {
            schedule = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().startingDailyAt(startingDailyAt).endingDailyAt(endingDailyAt).withInterval(params.getIntervalTime().intValue(), unit).onDaysOfTheWeek(days);
        }
        return schedule;
    }

    private <T extends Trigger> Trigger buildTrigger(ScheduleBuilder<T> schedule, SchedulerBaseParams params) {
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(params.getId()).withSchedule(schedule).usingJobData(JobKeyEnum.JOB_ARGS.name(), params.getArgs()).usingJobData(JobKeyEnum.JOB_RETRY_COUNT.name(), params.getRetryCount()).usingJobData(JobKeyEnum.JOB_RETRY_INTERVAL.name(), params.getRetryInterval());
        if (params.getEndDate() != null) {
            builder.endAt(new Date(DateUtil.epochMilli((LocalDateTime)params.getEndDate())));
        }
        if (params.getBeginDate() != null) {
            builder.startAt(new Date(DateUtil.epochMilli((LocalDateTime)params.getBeginDate())));
        }
        return builder.build();
    }

    private void validateScheduler() {
        if (this.scheduler == null) {
            throw new CavException("\u5b9a\u65f6\u4efb\u52a1\u5df2\u7981\u7528\uff01");
        }
    }

    private <T, U> void schedulerRun(T t, U u, JobOptEnum opt, BiConsumerException<T, U> consumer) {
        try {
            consumer.accept(t, u);
        }
        catch (Exception e) {
            throw new CavException(opt.getName() + "\u5b9a\u65f6\u4efb\u52a1\u9519\u8bef\uff01", e);
        }
    }

    private <T> void schedulerRun(T t, JobOptEnum opt, ConsumerException<T> consumer) {
        try {
            consumer.accept(t);
        }
        catch (Exception e) {
            throw new CavException(opt.getName() + "\u5b9a\u65f6\u4efb\u52a1\u9519\u8bef\uff01", e);
        }
    }
}

