/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.quartz.use.handler;

import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.quartz.use.enums.JobKeyEnum;
import cn.sinozg.applet.quartz.use.handler.JobHandler;
import cn.sinozg.applet.quartz.use.service.JobLogBaseService;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.Assert;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class JobHandlerInvoker
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(JobHandlerInvoker.class);
    @Resource
    private JobLogBaseService jobLogService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getMergedJobDataMap();
        String jobId = dataMap.getString(JobKeyEnum.JOB_ID.name());
        String jobName = dataMap.getString(JobKeyEnum.JOB_NAME.name());
        String beanName = dataMap.getString(JobKeyEnum.JOB_BEAN_NAME.name());
        String tenantId = dataMap.getString(JobKeyEnum.JOB_TENANT.name());
        String args = dataMap.getString(JobKeyEnum.JOB_ARGS.name());
        int retryCount = (Integer)dataMap.getOrDefault((Object)JobKeyEnum.JOB_RETRY_COUNT.name(), (Object)0);
        int retryInterval = (Integer)dataMap.getOrDefault((Object)JobKeyEnum.JOB_RETRY_INTERVAL.name(), (Object)0);
        String jobLogId = null;
        String data = null;
        Throwable exception = null;
        try {
            UserContextHolder.setTenantId((String)tenantId);
            jobLogId = this.jobLogService.createJobLog(jobId, jobName, LocalDateTime.now(), beanName, args, context.getRefireCount() + 1);
            data = this.executeInternal(beanName, args);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        this.updateJobLogResultAsync(jobLogId, data, exception, context);
        this.handleException(exception, context.getRefireCount(), retryCount, retryInterval);
    }

    private String executeInternal(String beanName, String args) throws Exception {
        JobHandler jobHandler = (JobHandler)SpringUtil.beanOfNmTp((String)beanName, JobHandler.class);
        Assert.notNull((Object)jobHandler, (String)"JobHandler \u4e0d\u4f1a\u4e3a\u7a7a");
        return jobHandler.execute(args);
    }

    private void updateJobLogResultAsync(String jobLogId, String data, Throwable exception, JobExecutionContext context) {
        boolean success = true;
        if (exception != null) {
            success = false;
            data = ExceptionUtils.getRootCauseMessage((Throwable)exception);
        }
        try {
            this.jobLogService.updateJobLogResultAsync(jobLogId, LocalDateTime.now(), success, data);
        }
        catch (Exception ex) {
            log.error("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25 jobKey\uff1a{}\uff0clogId\uff1a{} {}\uff0c data\uff1a {}", new Object[]{context.getJobDetail().getKey(), jobLogId, success, data});
        }
    }

    private void handleException(Throwable exception, int refireCount, int retryCount, int retryInterval) throws JobExecutionException {
        if (exception == null) {
            return;
        }
        if (refireCount >= retryCount) {
            throw new JobExecutionException(exception);
        }
        if (retryInterval > 0) {
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new JobExecutionException(exception, true);
    }
}

